/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.admin.ratelimit;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.admin.ratelimit.RateLimitHistoryEntry;
import com.atlassian.webdriver.bitbucket.page.admin.ratelimit.RateLimitSettingsAndHistoryPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import java.util.List;
import org.openqa.selenium.By;

public class RateLimitHistoryTable
extends AbstractElementPageObject {
    @Inject
    private PageElementFinder elementFinder;
    @ElementBy(cssSelector=".filterable-entity-table .entity-table")
    private PageElement historyTable;
    @ElementBy(className="rate-limit-history-refresh")
    private PageElement refreshButton;
    private final RateLimitSettingsAndHistoryPage historyPage;

    public RateLimitHistoryTable(@Nonnull PageElement container, RateLimitSettingsAndHistoryPage historyPage) {
        super(container);
        this.historyPage = historyPage;
    }

    public void refreshEntries() {
        this.refreshButton.click();
        Poller.waitUntilTrue((TimedQuery)this.refreshButton.timed().isEnabled());
        this.historyPage.closeFlags();
    }

    public TimedQuery<List<RateLimitHistoryEntry>> getEntries() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> {
            Poller.waitUntilTrue((TimedQuery)this.refreshButton.timed().isVisible());
            this.refreshEntries();
            return (List)this.historyTable.findAll(By.cssSelector((String)"tbody > tr")).stream().map(ElementUtils.bind(this.pageBinder, RateLimitHistoryEntry.class, this.pageBinder, this.elementFinder, this)).collect(MoreCollectors.toImmutableList());
        });
    }
}

