/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.admin.ratelimit;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.TimedUtils;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;

public class ManageUserExemptionDialog
extends AbstractElementPageObject {
    private static final Pattern SETTINGS_PATTERN = Pattern.compile(".*\\(([0-9]*)\\).*\\(([0-9]*)\\).*");
    private final PageElement allowUnlimitedRequestsRadioButton = this.find(By.cssSelector((String)"input[type='radio'][value='unlimited']"));
    private final PageElement cancelButton = this.find(By.cssSelector((String)"button[data-testid='cancel-rate-limit']"));
    private final PageElement capacityInput = this.find(By.cssSelector((String)"input[name='exemption-capacity']"));
    private final PageElement fillRateInput = this.find(By.cssSelector((String)"input[name='exemption-fillRate']"));
    private final PageElement globalSettings = this.find(By.tagName((String)"small"));
    private final PageElement setCustomSettingsRadioButton = this.find(By.cssSelector((String)"input[type='radio'][value='custom']"));
    private final PageElement submitButton = this.find(By.cssSelector((String)"button[type='submit']"));
    private final PageElement userNameSpan = this.find(By.cssSelector((String)".user-avatar-with-name .user-name"));
    @Inject
    private PageElementFinder elementFinder;

    public ManageUserExemptionDialog(@Nonnull PageElementFinder finder) {
        super(finder.find(By.cssSelector((String)"[data-testid='manage-exemption-dialog']")));
        Poller.waitUntilTrue((TimedQuery)this.container.timed().isPresent());
    }

    public ManageUserExemptionDialog allowUnlimitedRequests() {
        ElementUtils.waitUntilEnabled(this.allowUnlimitedRequestsRadioButton, this.timeouts).click();
        return this;
    }

    public <T> T cancel(Class<T> parentPageClass) {
        ElementUtils.waitUntilEnabled(this.cancelButton, this.timeouts).click();
        Poller.waitUntilFalse((TimedQuery)this.container.timed().isVisible());
        return (T)this.pageBinder.bind(parentPageClass, new Object[0]);
    }

    public TimedQuery<Integer> getGlobalBucketSize() {
        return TimedUtils.toMappable(this.globalSettings.timed().getText()).map(this::extractBucketSize).map(Integer::parseInt);
    }

    public TimedQuery<Integer> getGlobalRefillRate() {
        return TimedUtils.toMappable(this.globalSettings.timed().getText()).map(this::extractRefillRate).map(Integer::parseInt);
    }

    public TimedQuery<String> getUsername() {
        return this.userNameSpan.timed().getText();
    }

    public <T> T save(Class<T> parentPageClass) {
        ElementUtils.waitUntilEnabled(this.submitButton, this.timeouts).click();
        Poller.waitUntilFalse((TimedQuery)this.container.timed().isVisible());
        return (T)this.pageBinder.bind(parentPageClass, new Object[0]);
    }

    public TimedQuery<Iterable<String>> saveWithError() {
        ElementUtils.waitUntilEnabled(this.submitButton, this.timeouts).click();
        return Queries.forSupplier((Timeouts)this.timeouts, () -> (Iterable)this.elementFinder.findAll(By.cssSelector((String)"span.error")).stream().map(PageElement::getText).collect(MoreCollectors.toImmutableList()));
    }

    public SetCustomSettings setCustomSettings() {
        ElementUtils.waitUntilEnabled(this.setCustomSettingsRadioButton, this.timeouts).click();
        return new SetCustomSettings();
    }

    private String[] extractBucketSettings(String input) {
        Matcher matcher = SETTINGS_PATTERN.matcher(input);
        if (matcher.groupCount() == 2 && matcher.find()) {
            return new String[]{matcher.group(1), matcher.group(2)};
        }
        throw new IllegalArgumentException("Unexpected global settings description in the dialog");
    }

    private String extractBucketSize(String input) {
        String[] values = this.extractBucketSettings(input);
        return values[0];
    }

    private String extractRefillRate(String input) {
        String[] values = this.extractBucketSettings(input);
        return values[1];
    }

    public class SetCustomSettings {
        public <T> T save(Class<T> parentPageClass) {
            return ManageUserExemptionDialog.this.save(parentPageClass);
        }

        public TimedQuery<Iterable<String>> saveWithError() {
            return ManageUserExemptionDialog.this.saveWithError();
        }

        public SetCustomSettings setMaxTokens(@Nonnull String maxTokens) {
            ElementUtils.waitUntilEnabled(ManageUserExemptionDialog.this.capacityInput, ManageUserExemptionDialog.this.timeouts).clear().type(new CharSequence[]{maxTokens});
            return this;
        }

        public SetCustomSettings setReplacementRate(@Nonnull String replacementRate) {
            ElementUtils.waitUntilEnabled(ManageUserExemptionDialog.this.fillRateInput, ManageUserExemptionDialog.this.timeouts).clear().type(new CharSequence[]{replacementRate});
            return this;
        }
    }
}

