/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.GroupOption;
import com.atlassian.webdriver.bitbucket.element.GroupSelect;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

public class UserGroupsTable
extends AbstractElementPageObject {
    @Inject
    protected PageElementFinder elementFinder;
    @ElementBy(className="add-button")
    private PageElement addButton;
    private GroupSelect groupsPicker;
    private Long lastUpdated;

    public UserGroupsTable(@Nonnull PageElement container) {
        super(container);
    }

    @WaitUntil
    protected void waitUntilLoaded() {
        ElementUtils.waitUntilUpdated(this.container, this.lastUpdated);
        this.lastUpdated = ElementUtils.getLastUpdated(this.container);
    }

    @Init
    protected void initGroupPicker() {
        this.groupsPicker = (GroupSelect)this.pageBinder.bind(GroupSelect.class, new Object[]{this.container.find(By.className((String)"groups-multi-selector"))});
    }

    public UserGroupsTable loadNextPage() {
        ElementUtils.scrollDocumentAndWait(this.container);
        return this;
    }

    public UserGroupsTable add(String name) {
        return this.add(name, false);
    }

    public UserGroupsTable add(String name, boolean expectError) {
        this.groupsPicker.type(name);
        GroupOption option = (GroupOption)this.groupsPicker.findOption(opt -> name.equals(opt.getGroupName()));
        this.groupsPicker.selectOption(option);
        this.addButton.click();
        if (!expectError) {
            this.waitUntilLoaded();
        } else {
            this.waitErrorMessage();
        }
        return this;
    }

    public UserGroupsTable remove(String name) {
        return this.remove(name, false);
    }

    public UserGroupsTable remove(String name, boolean expectError) {
        this.find(name).delete();
        if (!expectError) {
            this.waitUntilLoaded();
        } else {
            this.waitErrorMessage();
        }
        return this;
    }

    public boolean canAdd(String name) {
        this.groupsPicker.type(name);
        boolean canAdd = (Boolean)this.groupsPicker.hasOption(opt -> name.equals(opt != null ? opt.getGroupName() : null)).byDefaultTimeout();
        this.groupsPicker.type(new CharSequence[]{Keys.ESCAPE});
        return canAdd;
    }

    public List<Row> list() {
        return this.container.findAll(By.cssSelector((String)"tbody > tr"), Row.class);
    }

    public Row find(String name) {
        return this.list().stream().filter(row -> row.getName().equals(name)).findFirst().orElse(null);
    }

    private void waitErrorMessage() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"aui-message-error")).timed().isVisible());
    }

    public static class Row
    extends LegacyElementPageObject {
        public Row(@Nonnull PageElement container) {
            super(container);
        }

        public Row(WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        public String getName() {
            return this.find(By.cssSelector((String)"[data-groupname]")).getAttribute("data-groupname");
        }

        public void delete() {
            PageElement delete = this.getDeleteButton();
            ElementUtils.makeVisible(delete);
            delete.click();
        }

        private PageElement getDeleteButton() {
            return this.find(By.className((String)"delete-button"));
        }
    }
}

