/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementActions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.utils.by.ByDataAttribute;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.util.Objects;
import org.openqa.selenium.By;

public class SearchableSelectorDialog {
    @Inject
    protected PageElementActions actions;
    private final PageElement dialog;

    public SearchableSelectorDialog(PageElement dialog) {
        this.dialog = Objects.requireNonNull(dialog, "dialog");
    }

    public SearchableSelectorDialog filterBy(String filterText) {
        PageElement filterInput = this.dialog.find(By.className((String)"filter"));
        Preconditions.checkState((boolean)filterInput.isPresent(), (Object)"Searchable selector is not filterable");
        ElementUtils.waitUntilUpdated(this.getResultsList(), () -> filterInput.type(new CharSequence[]{filterText}));
        return this;
    }

    public TimedCondition isLoadingPage() {
        return this.dialog.find(By.className((String)"spinner-wrapper")).timed().isVisible();
    }

    public TimedCondition isOpen() {
        return this.dialog.timed().isVisible();
    }

    public boolean hasTabs() {
        return this.dialog.find(By.className((String)"tabs-menu")).isPresent();
    }

    public int numberOfResults() {
        return this.getResultsList().findAll(By.className((String)"result")).size();
    }

    public PageElement getResultsList() {
        String resultListSelector = this.hasTabs() ? ".active-pane .results-list" : ".results-list";
        return this.dialog.find(By.cssSelector((String)resultListSelector));
    }

    public void selectItemByName(String itemName) {
        PageElement pageElement = this.getResultsList().find(By.partialLinkText((String)itemName));
        this.selectDropdownElement(pageElement);
        Poller.waitUntilFalse((TimedQuery)this.dialog.timed().isVisible());
    }

    public void selectItemByExactName(String itemName) {
        PageElement pageElement = this.getResultsList().find(By.linkText((String)itemName));
        this.selectDropdownElement(pageElement);
        Poller.waitUntilFalse((TimedQuery)this.dialog.timed().isVisible());
    }

    public void selectItemById(String dataId) {
        PageElement item = this.getResultsList().find(ByDataAttribute.byData((String)"id", (String)dataId));
        this.selectDropdownElement(item);
        Poller.waitUntilFalse((TimedQuery)this.dialog.timed().isVisible());
    }

    public SearchableSelectorDialog selectBranches() {
        return this.selectTab("Branches");
    }

    public SearchableSelectorDialog selectTags() {
        return this.selectTab("Tags");
    }

    public SearchableSelectorDialog selectCommits() {
        return this.selectTab("Commits");
    }

    private SearchableSelectorDialog selectTab(String linkText) {
        PageElement tab = this.dialog.find(By.linkText((String)linkText)).click();
        Poller.waitUntilTrue((TimedQuery)tab.timed().hasAttribute("aria-selected", "true"));
        return this;
    }

    private void selectDropdownElement(PageElement element) {
        ElementUtils.scrollIntoView(element);
        this.actions.moveToElement(element).perform();
        element.click();
    }
}

