/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.RepositoryShortcutDeleteDialog;
import com.atlassian.webdriver.bitbucket.element.RepositoryShortcutEditDialog;
import jakarta.inject.Inject;
import org.openqa.selenium.By;

public class RepositoryShortcut
extends AbstractElementPageObject {
    @Inject
    private PageElementFinder elementFinder;
    private final int id = this.getFrontEndId();

    public RepositoryShortcut(PageElement pageElement) {
        super(pageElement);
    }

    public String getLabel() {
        return this.find(By.cssSelector((String)"a > .aui-nav-item-label")).getText();
    }

    public String getUrl() {
        return this.find(By.cssSelector((String)"a")).getAttribute("href");
    }

    public RepositoryShortcutDeleteDialog openDeleteDialog() {
        return (RepositoryShortcutDeleteDialog)this.pageBinder.bind(RepositoryShortcutDeleteDialog.class, new Object[]{this.openDialog("delete-shortcut", "delete")});
    }

    public RepositoryShortcutEditDialog openEditDialog() {
        return (RepositoryShortcutEditDialog)this.pageBinder.bind(RepositoryShortcutEditDialog.class, new Object[]{this.openDialog("edit-shortcut", "edit")});
    }

    private void clickActionMenuTrigger() {
        PageElement actionMenuTrigger = this.find(By.className((String)"actions-trigger"));
        actionMenuTrigger.javascript().mouse().mouseover();
        actionMenuTrigger.click();
    }

    private PageElement getActionMenu() {
        PageElement actionMenu = this.elementFinder.find(By.id((String)("repo-shortcut-url-" + this.id + "-actions-dialog")));
        Poller.waitUntilTrue((String)"The action menu for the repository shortcut should be visible", (TimedQuery)actionMenu.timed().isVisible());
        return actionMenu;
    }

    private int getFrontEndId() {
        String id = this.find(By.cssSelector((String)"a")).getId();
        return Integer.parseInt(id.split("-")[3]);
    }

    private PageElement openDialog(String triggerClass, String dialogId) {
        this.clickActionMenuTrigger();
        this.getActionMenu().find(By.className((String)triggerClass)).click();
        PageElement dialog = this.elementFinder.find(By.id((String)("repo-shortcut-url-" + this.id + "-" + dialogId + "-dialog")));
        Poller.waitUntilTrue((String)("The " + dialogId + " dialog for the repository shortcut should be visible"), (TimedQuery)dialog.timed().hasAttribute("open", "true"));
        return dialog;
    }
}

