/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.notification.PullRequestNotificationScope;
import com.atlassian.webdriver.bitbucket.element.notification.PushNotificationScope;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.Locators;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.openqa.selenium.By;

public class RepositoryNotificationSettingsTable
extends AbstractElementPageObject {
    public RepositoryNotificationSettingsTable(@Nonnull PageElement container) {
        super(container);
    }

    public List<Entry> getRows() {
        Poller.waitUntilFalse((TimedQuery)this.container.find(By.cssSelector((String)"aui-spinner")).timed().isPresent());
        return (List)this.container.findAll(Locators.tableRow(), TimeoutType.PAGE_LOAD).stream().map(entry -> ElementUtils.bind(this.pageBinder, Entry.class, new Object[0]).apply((PageElement)entry)).collect(MoreCollectors.toImmutableList());
    }

    public static class Entry
    extends AbstractElementPageObject {
        public Entry(@Nonnull PageElement container) {
            super(container);
        }

        public Entry clickEdit() {
            this.container.find(By.cssSelector((String)".repository-actions .edit-repository-settings")).click();
            return this;
        }

        public Entry clickWatchToggle() {
            this.container.find(By.cssSelector((String)".repository-actions .toggle-watch-repository")).click();
            return this;
        }

        public String getProjectName() {
            return this.container.find(By.cssSelector((String)".repository-name .project")).getText();
        }

        public PullRequestNotificationScope getPullRequestNotificationScope() {
            return PullRequestNotificationScope.valueOf(this.container.find(By.cssSelector((String)".pull-request-notification-scope")).getAttribute("data-scope"));
        }

        public PushNotificationScope getPushNotificationScope() {
            return PushNotificationScope.valueOf(this.container.find(By.cssSelector((String)".commit-notification-scope")).getAttribute("data-scope"));
        }

        public String getRepositoryName() {
            return this.container.find(By.cssSelector((String)".repository-name .repository")).getText();
        }
    }
}

