/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.util.EventUtils;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import java.util.Objects;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;

public abstract class AbstractElementPageObject {
    @Inject
    protected JavascriptExecutor javascriptExecutor;
    @Inject
    protected PageBinder pageBinder;
    @Inject
    protected Timeouts timeouts;
    protected final PageElement container;

    protected AbstractElementPageObject(@Nonnull PageElement container) {
        this.container = Objects.requireNonNull(container, "container");
    }

    @Nonnull
    protected PageElement find(@Nonnull By locator) {
        return this.container.find(locator);
    }

    @Nonnull
    protected Iterable<PageElement> findAll(@Nonnull By locator) {
        return this.container.findAll(locator);
    }

    public void waitUntilEventFired(String eventName, Runnable runnable) {
        EventUtils.waitUntilEventFired(eventName, runnable, this.javascriptExecutor, this.timeouts);
    }
}

