/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.page.admin.BitbucketAdminPage;

public class LookAndFeelPage
extends BitbucketAdminPage {
    private static final String URL = "/plugins/servlet/lookandfeel";
    @ElementBy(cssSelector="#favicon-upload")
    private PageElement faviconInputElement;
    @ElementBy(cssSelector="link[rel=\"shortcut icon\"]")
    private PageElement faviconLinkElement;
    @ElementBy(cssSelector="#header-colour")
    private PageElement headerColorButton;
    @ElementBy(cssSelector=".aui-header")
    private PageElement headerElement;
    @ElementBy(cssSelector="#logo a")
    private PageElement logoElement;
    @ElementBy(cssSelector="#logo-upload")
    private PageElement logoInputElement;
    @ElementBy(cssSelector="#primary-colour")
    private PageElement primaryColorButton;
    @ElementBy(cssSelector="#look-and-feel-reset-default")
    private PageElement resetButton;
    @ElementBy(cssSelector="#look-and-feel-submit")
    private PageElement saveButton;

    public LookAndFeelPage() {
    }

    public LookAndFeelPage(String webSudoPassword) {
        super(webSudoPassword);
    }

    public String getCurrentFaviconImg() {
        return this.faviconLinkElement.getAttribute("href");
    }

    public String getCurrentHeaderColor() {
        return this.headerElement.javascript().execute("return getComputedStyle(arguments[0]).backgroundColor;", new Object[0]).toString();
    }

    public String getCurrentLogoImg() {
        return this.logoElement.javascript().execute("return getComputedStyle(arguments[0]).backgroundImage;", new Object[0]).toString();
    }

    public String getCurrentPrimaryColor() {
        return this.resetButton.javascript().execute("return getComputedStyle(arguments[0]).color;", new Object[0]).toString();
    }

    public void resetDefault() {
        this.resetButton.click();
        this.saveButton.click();
    }

    public void save() {
        this.saveButton.click();
    }

    public void setFavicon(String base64IMG) {
        this.faviconInputElement.javascript().execute("$(arguments[0]).val('" + base64IMG + "')", new Object[0]);
    }

    public void setHeaderColor(String color) {
        this.setSpectrumColor(this.headerColorButton, color);
    }

    public void setLogo(String base64IMG) {
        this.logoInputElement.javascript().execute("$(arguments[0]).val('" + base64IMG + "')", new Object[0]);
    }

    public void setPrimaryColor(String color) {
        this.setSpectrumColor(this.primaryColorButton, color);
    }

    public void setSpectrumColor(PageElement element, String color) {
        element.javascript().execute("$(arguments[0]).spectrum('set', '" + color + "');", new Object[0]);
    }

    public String getUrl() {
        return URL;
    }
}

