/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page.next;

import com.atlassian.bitbucket.pageobjects.element.next.FileBreadcrumbs;
import com.atlassian.bitbucket.pageobjects.page.next.BranchLayoutPage;
import com.atlassian.pageobjects.elements.ElementBy;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public abstract class FileLayoutPage
extends BranchLayoutPage {
    protected final String path;
    protected final RevisionSpecifier revisionSpecifier;
    @ElementBy(className="file-breadcrumbs", pageElementClass=FileBreadcrumbs.class)
    private FileBreadcrumbs breadcrumbs;

    public FileLayoutPage(String projectKey, String repoSlug, String path) {
        this(projectKey, repoSlug, path, null);
    }

    public FileLayoutPage(String projectKey, String repoSlug, String path, RevisionSpecifier revisionSpecifier) {
        super(projectKey, repoSlug);
        this.revisionSpecifier = revisionSpecifier;
        this.path = !path.isEmpty() && !path.startsWith("/") ? "/" + path : path;
    }

    public FileBreadcrumbs getBreadcrumbs() {
        return this.breadcrumbs;
    }

    public String getUrl() {
        Object qs = "";
        if (this.revisionSpecifier != null) {
            Object untilQs;
            String at = this.revisionSpecifier.at;
            String until = this.revisionSpecifier.until;
            Object atQs = StringUtils.isNotBlank((CharSequence)at) ? "at=" + at : "";
            Object object = untilQs = StringUtils.isNotBlank((CharSequence)until) ? "until=" + until : "";
            if (!StringUtils.isBlank((CharSequence)atQs) && !StringUtils.isBlank((CharSequence)untilQs)) {
                qs = (String)qs + "?" + (String)atQs + "&" + (String)untilQs;
            } else if (!StringUtils.isBlank((CharSequence)atQs)) {
                qs = (String)qs + "?" + (String)atQs;
            } else if (!StringUtils.isBlank((CharSequence)untilQs)) {
                qs = (String)qs + "?" + (String)untilQs;
            }
        }
        String repoUrl = this.projectKey.startsWith("~") ? "/users/" + this.projectKey.replace("~", "").toLowerCase(Locale.US) + "/repos/" + this.slug : "/projects/" + this.projectKey + "/repos/" + this.slug;
        return repoUrl + "/" + this.getPathComponent() + this.path + (String)qs;
    }

    protected abstract String getPathComponent();

    public static class RevisionSpecifier {
        public final String at;
        public final String until;

        public RevisionSpecifier(String at, String until) {
            this.until = until;
            this.at = at;
        }
    }
}

