/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;

public class RepositorySearchIndexingSettingsPage
extends BaseRepositoryPage {
    @ElementBy(id="repository-search-indexing-container")
    private PageElement container;
    @ElementBy(cssSelector="[data-testid='last-indexed-commit-id']")
    private PageElement lastIndexedCommitId;
    @ElementBy(cssSelector="[data-testid='refresh-button']")
    private PageElement refreshButton;
    @ElementBy(cssSelector="[data-testid='search-indexing-lozenge']")
    private PageElement searchIndexingLozenge;

    public RepositorySearchIndexingSettingsPage(String projectKey, String slug) {
        super(projectKey, slug);
    }

    public PageElement getLastIndexedCommitId() {
        return this.lastIndexedCommitId;
    }

    public PageElement getStatusLozenge() {
        return this.searchIndexingLozenge;
    }

    public String getUrl() {
        return String.format("/plugins/servlet/search-indexing/%s/%s", this.getProjectKey(), this.getSlug());
    }

    public TimedCondition isRefreshButtonVisible() {
        return this.refreshButton.timed().isVisible();
    }

    public void waitUntilLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.container.timed().isVisible());
    }
}

