/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page;

import com.atlassian.bitbucket.pageobjects.page.RepositoryAccessKeyFormPage;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AccessKeyRow;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.util.Locators;
import java.util.List;
import org.openqa.selenium.By;

public class RepositoryAccessKeySettingsPage
extends BaseRepositoryPage {
    @ElementBy(className="add-key-button")
    private PageElement addKeyButton;
    @ElementBy(className="ssh-keys-table")
    private PageElement sshKeysTable;
    @ElementBy(cssSelector="[data-testid='ssh-key-actions-edit']")
    private PageElement sshKeyActionsEdit;

    public RepositoryAccessKeySettingsPage(String projectKey, String slug) {
        super(projectKey, slug);
    }

    public RepositoryAccessKeyFormPage clickAddKeyButton() {
        Poller.waitUntilTrue((TimedQuery)this.isAddKeyButtonVisible());
        this.addKeyButton.click();
        return (RepositoryAccessKeyFormPage)this.pageBinder.bind(RepositoryAccessKeyFormPage.class, new Object[]{this.getProjectKey(), this.getSlug()});
    }

    public RepositoryAccessKeyFormPage clickEditByKeyId(int keyId) {
        Poller.waitUntilTrue((TimedQuery)this.isSshKeysTablePresent());
        AccessKeyRow accessKeyRow = this.getAccessKeys().get(0);
        accessKeyRow.openDropdown();
        Poller.waitUntilTrue((TimedQuery)this.isDropdownVisible());
        this.sshKeyActionsEdit.click();
        return (RepositoryAccessKeyFormPage)this.pageBinder.bind(RepositoryAccessKeyFormPage.class, new Object[]{this.getProjectKey(), this.getSlug(), keyId});
    }

    public TimedCondition isAddKeyButtonVisible() {
        return this.addKeyButton.timed().isVisible();
    }

    public TimedCondition isDropdownVisible() {
        return this.sshKeyActionsEdit.timed().isVisible();
    }

    public TimedCondition isSshKeysTablePresent() {
        return this.sshKeysTable.timed().isPresent();
    }

    public List<AccessKeyRow> getAccessKeys() {
        return this.sshKeysTable.findAll(Locators.tableRow(), AccessKeyRow.class);
    }

    public String getUrl() {
        return String.format("/plugins/servlet/ssh/projects/%s/repos/%s/keys", this.getProjectKey(), this.getSlug());
    }

    public boolean hasActions(boolean value) {
        return this.getAccessKeys().stream().allMatch(row -> value == row.hasActions());
    }

    public TimedCondition hasAddKeyButton() {
        return this.elementFinder.find(By.className((String)"add-key-button")).timed().isVisible();
    }

    public boolean hasRestrictionBanner() {
        PageElement element = this.elementFinder.find(By.className((String)"locked-settings-banner")).withTimeout(TimeoutType.PAGE_LOAD);
        return element.isVisible() && element.isPresent();
    }

    public boolean isEmpty() {
        return !this.sshKeysTable.isPresent();
    }

    public void waitUntilLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.sshKeysTable.timed().isVisible());
    }
}

