/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.next;

import com.atlassian.bitbucket.hamcrest.IsBlankString;
import com.atlassian.bitbucket.pageobjects.element.next.SearchableSelectorDialog;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import jakarta.inject.Inject;
import java.util.Objects;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public class SearchableSelector {
    private By dialogLocator;
    @Inject
    private PageElementFinder elementFinder;
    private PageElement inputField;
    @Inject
    private PageBinder pageBinder;
    private PageElement trigger;

    public SearchableSelector(PageElement trigger, By dialogLocator) {
        this(trigger, dialogLocator, null);
    }

    public SearchableSelector(PageElement trigger, By dialogLocator, PageElement inputField) {
        this.trigger = Objects.requireNonNull(trigger, "trigger");
        this.dialogLocator = Objects.requireNonNull(dialogLocator, "dialogLocator");
        this.inputField = inputField;
    }

    public void clearInput() {
        if (this.inputField != null && this.inputField.isVisible()) {
            this.inputField.clear();
            Poller.waitUntil((TimedQuery)this.inputField.timed().getValue(), (Matcher)IsBlankString.blank());
        }
    }

    public SearchableSelectorDialog getDialog() {
        return (SearchableSelectorDialog)this.pageBinder.bind(SearchableSelectorDialog.class, new Object[]{this.elementFinder.find(this.dialogLocator)});
    }

    public String getSelectedItemName() {
        return this.elementFinder.find(By.className((String)"selector-toggle-button-content")).getText();
    }

    public TimedQuery<String> getSelectedValue() {
        return this.getValueInput().timed().getValue();
    }

    public String getTriggerText() {
        return this.trigger.getText();
    }

    public TimedCondition hasValue() {
        return Conditions.forMatcher(this.getSelectedValue(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
    }

    public SearchableSelectorDialog open() {
        SearchableSelectorDialog searchableSelectorDialog = this.getDialog();
        if (!((Boolean)searchableSelectorDialog.isOpen().now()).booleanValue()) {
            this.trigger.click();
        }
        Poller.waitUntilTrue((TimedQuery)searchableSelectorDialog.isOpen());
        Poller.waitUntilFalse((TimedQuery)searchableSelectorDialog.isLoadingPage());
        return searchableSelectorDialog;
    }

    private PageElement getValueInput() {
        Objects.requireNonNull(this.inputField, "Input field must be provided to get the value input");
        return this.inputField;
    }
}

