/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.commit.details;

import com.atlassian.bitbucket.pageobjects.element.PullRequestList;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import org.openqa.selenium.By;

public class CommitPullRequestListDialog
extends AbstractElementPageObject {
    private final PageElement pullRequestList = this.find(By.className((String)"pull-requests-list-table"));
    @Inject
    private PageElementFinder elementFinder;

    public CommitPullRequestListDialog(@Nonnull PageElement container) {
        super(container);
    }

    public void close() {
        this.elementFinder.find(By.cssSelector((String)"[data-testid='close-modal-button']")).click();
        Poller.waitUntilFalse((TimedQuery)this.pullRequestList.timed().isVisible());
    }

    public PullRequestList getPullRequestList() {
        return (PullRequestList)this.pageBinder.bind(PullRequestList.class, new Object[]{this.pullRequestList});
    }

    public TimedCondition isLastPage() {
        return this.container.timed().hasAttribute("data-is-last-page", "true");
    }

    public TimedCondition isOpen() {
        return this.pullRequestList.timed().isVisible();
    }

    public void loadNextPage() {
        Poller.waitUntilFalse((TimedQuery)this.elementFinder.find(By.className((String)"pull-requests-modal-spinner")).timed().isPresent());
        this.scrollToBottom();
        Poller.waitUntilFalse((TimedQuery)this.elementFinder.find(By.className((String)"pull-requests-modal-spinner")).timed().isPresent());
    }

    private void scrollToBottom() {
        this.container.javascript().execute("scrollableContainer = document.querySelector('table.pull-requests-list-table');scrollableContainer.style.cssText += 'scroll-margin-bottom:100px;';scrollableContainer.scrollIntoView(false);", new Object[0]);
    }
}

