/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.comments;

import com.atlassian.bitbucket.pageobjects.element.ConfirmDialog;
import com.atlassian.bitbucket.pageobjects.element.RenderedMarkup;
import com.atlassian.bitbucket.pageobjects.element.comments.CommentForm;
import com.atlassian.bitbucket.pageobjects.element.comments.EditCommentForm;
import com.atlassian.bitbucket.pageobjects.element.comments.ReplyCommentForm;
import com.atlassian.bitbucket.pageobjects.element.tasks.Task;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.integration.jira.element.JiraCreateIssueDialog;
import com.atlassian.webdriver.integration.jira.element.JiraIssueList;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import java.util.List;
import org.openqa.selenium.By;

public class Comment
extends RenderedMarkup {
    private static final String CREATE_JIRA_ISSUE_TEXT = "Create Jira issue";
    private final PageElement author = this.find(By.cssSelector((String)".comment .user-name"));
    private final PageElement collapseButton = this.find(By.className((String)"collapse-button"));
    private final PageElement commentBody = this.find(By.cssSelector((String)".comment-content .comment-body"));
    private final long commentId = Long.parseLong(this.find(By.cssSelector((String)"[data-comment-id]")).getAttribute("data-comment-id"));
    private final int commentVersion = Integer.parseInt(this.find(By.cssSelector((String)"[data-comment-version]")).getAttribute("data-comment-version"));
    private final PageElement copyLinkButton = this.find(By.className((String)"copy-comment-link"));
    private final PageElement editButton = this.find(By.cssSelector((String)"[data-testid='comment-edit-button']"));
    private final PageElement emojiPicker = this.find(By.cssSelector((String)"[data-testid='emoji-picker']"));
    private final PageElement extensionPanelWrapper = this.find(By.cssSelector((String)".comments-extension-panel-wrapper"));
    private final PageElement jiraIssueList = this.find(By.className((String)"jira-issues-list"));
    private final PageElement lineMarkers = this.find(By.cssSelector((String)"[data-testid='line-markers']"));
    private final PageElement moreActionButton = this.find(By.cssSelector((String)"[data-testid='comment-options--trigger']"));
    private final PageElement pendingLozenge = this.find(By.cssSelector((String)"[data-testid='pending-lozenge']"));
    private final PageElement reactionList = this.find(By.className((String)"comment-reaction-list"));
    private final PageElement reactionsButton = this.find(By.cssSelector((String)"[data-testid='comment-add-reaction-button']"));
    private final PageElement replyButton = this.find(By.cssSelector((String)"[data-testid='comment-reply-button']"));
    private final PageElement replyEditor = this.find(By.className((String)"comment-editor-reply"));
    private final PageElement resolveButton = this.find(By.className((String)"comment-resolve-button"));
    private final PageElement resolveLozenge = this.find(By.cssSelector((String)"[data-testid='resolved-lozenge']"));
    @ElementBy(cssSelector="[data-testid='delete-comment-modal']")
    private PageElement deleteDialog;
    @Inject
    private PageElementFinder elementFinder;

    public Comment(@Nonnull PageElement container) {
        super(container);
    }

    public Task asTask() {
        return (Task)this.pageBinder.bind(Task.class, new Object[]{this.container});
    }

    public JiraCreateIssueDialog clickCreateJiraIssue() {
        this.moreActionButton.withTimeout(TimeoutType.UI_ACTION).click();
        PageElement moreActionOptions = this.elementFinder.find(By.cssSelector((String)"[data-testid='comment-options--content']"));
        Poller.waitUntilTrue((TimedQuery)moreActionOptions.timed().isVisible());
        PageElement createJiraButton = moreActionOptions.find(By.xpath((String)"//*[.=('Create Jira issue')]"));
        createJiraButton.withTimeout(TimeoutType.UI_ACTION).click();
        return (JiraCreateIssueDialog)this.pageBinder.bind(JiraCreateIssueDialog.class, new Object[0]);
    }

    public CommentForm clickEdit() {
        this.editButton.click();
        return this.getEditForm();
    }

    public Comment clickReaction(String reaction) {
        PageElement emojiPicker = this.openReactionPicker();
        PageElement emoji = emojiPicker.find(By.cssSelector((String)(".emoji-picker-category.popular-emojis [aria-label^=\":" + reaction + ":\"]")));
        emoji.withTimeout(TimeoutType.UI_ACTION).click();
        return (Comment)this.pageBinder.bind(Comment.class, new Object[]{this.container});
    }

    public CommentForm clickReply() {
        this.replyButton.click();
        return this.getReplyForm();
    }

    public Task convertToTask() {
        this.clickConvert();
        return this.asTask();
    }

    public void delete() {
        PageElement commentById = this.find(By.cssSelector((String)("[data-comment-id='" + this.getCommentId() + "']")));
        this.moreActionButton.click();
        this.elementFinder.find(By.cssSelector((String)"[data-testid='delete-comment']")).withTimeout(TimeoutType.UI_ACTION).click();
        ConfirmDialog confirmDialog = (ConfirmDialog)this.pageBinder.bind(ConfirmDialog.class, new Object[]{this.deleteDialog});
        confirmDialog.clickButton("Delete");
        Poller.waitUntilFalse((TimedQuery)commentById.timed().isPresent());
    }

    public Comment editAndSubmit(String commentText) {
        return ((CommentForm)this.clickEdit().setText(commentText)).save();
    }

    public String getAuthor() {
        return this.author.getText();
    }

    public PageElement getCommentActionExtension(String text) {
        this.moreActionButton.withTimeout(TimeoutType.UI_ACTION).click();
        PageElement moreActionOptions = this.elementFinder.find(By.cssSelector((String)"[data-testid='comment-options--content']"));
        Poller.waitUntilTrue((TimedQuery)moreActionOptions.timed().isVisible());
        return moreActionOptions.find(By.xpath((String)("//*[.=('" + text + "')]")));
    }

    public PageElement getCommentExtensionPanel() {
        return this.extensionPanelWrapper;
    }

    public long getCommentId() {
        return this.commentId;
    }

    public String getCommentLineMarkers() {
        return this.lineMarkers.getText();
    }

    public String getCommentText() {
        return this.commentBody.getText();
    }

    public String getCommentHtml() {
        return ElementUtils.getHtml(this.commentBody);
    }

    public int getCommentVersion() {
        return this.commentVersion;
    }

    public String getCopyLinkValue() {
        return this.copyLinkButton.getAttribute("data-value");
    }

    public JiraIssueList getJiraIssueList() {
        return (JiraIssueList)this.pageBinder.bind(JiraIssueList.class, new Object[]{this.jiraIssueList});
    }

    public Comment getLastReply() {
        List<Comment> replies = this.getReplies();
        return replies.get(replies.size() - 1);
    }

    public TimedQuery<String> getNumberOfReactions(String reaction) {
        PageElement reactionItem = this.getReaction(reaction);
        return reactionItem.find(By.className((String)"reaction-count")).timed().getText();
    }

    public TimedQuery<String> getReactionContent(String reaction) {
        PageElement reactionItem = this.getReaction(reaction);
        return reactionItem.timed().getAttribute("aria-label");
    }

    public List<Comment> getReplies() {
        return (List)this.find(By.cssSelector((String)"ol.replies")).findAll(By.cssSelector((String)":scope > li")).stream().map(ElementUtils.bind(this.pageBinder, Comment.class, new Object[0])).collect(MoreCollectors.toImmutableList());
    }

    public CommentForm getReplyForm() {
        Poller.waitUntilTrue((TimedQuery)this.replyEditor.timed().isVisible());
        return (CommentForm)this.pageBinder.bind(ReplyCommentForm.class, new Object[]{this.replyEditor, this});
    }

    public TimedCondition hasCommentBody() {
        return this.commentBody.timed().isVisible();
    }

    public TimedCondition hasCommonReactions() {
        return this.find(By.cssSelector((String)".emoji-picker-category.popular-emojis")).timed().isPresent();
    }

    public TimedCondition hasLastUsedReaction(String reaction) {
        PageElement emojiPicker = this.openReactionPicker();
        PageElement emoji = emojiPicker.find(By.cssSelector((String)(".last-used-emojis [aria-label^=':" + reaction + ":']")));
        return emoji.timed().isPresent();
    }

    public TimedCondition hasReacted(String reaction) {
        PageElement reactedItem = this.reactionList.find(By.cssSelector((String)("button.reacted .reaction-content." + reaction)));
        return reactedItem.timed().isPresent();
    }

    public TimedCondition hasReaction(String reaction) {
        PageElement reactionItem = this.getReaction(reaction);
        return reactionItem.timed().isPresent();
    }

    public TimedCondition hasReplyButton() {
        return this.replyButton.timed().isVisible();
    }

    public TimedCondition hasReplyForm() {
        return this.replyEditor.timed().isVisible();
    }

    public TimedCondition hasResolvedLozenge() {
        return this.resolveLozenge.timed().isVisible();
    }

    public TimedCondition isPendingComment() {
        return this.pendingLozenge.timed().isVisible();
    }

    public TimedCondition isVisible() {
        return this.container.timed().isVisible();
    }

    public Comment replyWithComment(String text) {
        return ((CommentForm)this.clickReply().setText(text)).submitComment();
    }

    public Task replyWithTask(String text) {
        return ((CommentForm)this.clickReply().setText(text)).submitTask();
    }

    public Comment searchAndClickReaction(String reaction) {
        PageElement emojiPicker = this.openReactionPicker();
        PageElement emojiPickerSearchInput = emojiPicker.find(By.cssSelector((String)".emoji-picker .emoji-picker-search input"));
        emojiPickerSearchInput.type(new CharSequence[]{reaction});
        PageElement emoji = emojiPicker.find(By.cssSelector((String)(".emoji-picker-category.search-results button[aria-label^=\":" + reaction + ":\"]")));
        emoji.withTimeout(TimeoutType.UI_ACTION).click();
        return (Comment)this.pageBinder.bind(Comment.class, new Object[]{this.container});
    }

    public Comment toggleCollapse() {
        this.collapseButton.click();
        return (Comment)this.pageBinder.bind(Comment.class, new Object[]{this.container});
    }

    public Comment toggleResolve() {
        Poller.waitUntilTrue((TimedQuery)this.hasCommentBody());
        this.resolveButton.click();
        return (Comment)this.pageBinder.bind(Comment.class, new Object[]{this.container});
    }

    protected Comment clickConvert() {
        this.moreActionButton.withTimeout(TimeoutType.UI_ACTION).click();
        PageElement convertButton = this.elementFinder.find(By.cssSelector((String)"[data-testid='convert-comment']"));
        convertButton.withTimeout(TimeoutType.UI_ACTION).click();
        return this;
    }

    public CommentForm getEditForm() {
        PageElement editEditor = this.elementFinder.find(By.className((String)"comment-editor-edit-comment"));
        Poller.waitUntilTrue((TimedQuery)editEditor.timed().isVisible());
        return (CommentForm)this.pageBinder.bind(EditCommentForm.class, new Object[]{this.container, this});
    }

    public PageElement getExtensionPanel() {
        return this.elementFinder.find(By.className((String)"comments-extension-panel-wrapper"));
    }

    private PageElement getReaction(String reaction) {
        return this.reactionList.find(By.cssSelector((String)(".reaction-content." + reaction)));
    }

    private PageElement openReactionPicker() {
        if (!this.emojiPicker.isPresent()) {
            this.reactionsButton.click();
            Poller.waitUntilTrue((TimedQuery)this.emojiPicker.timed().isVisible());
        }
        return this.emojiPicker;
    }
}

