/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.openqa.selenium.By;

public class RepositorySelector
extends AbstractElementPageObject {
    private final PageElement dropdownControl = this.find(By.className((String)"filterable-tabs__control"));
    private final PageElement dropdownSpinner = this.find(By.cssSelector((String)".filterable-tabs__indicators circle"));
    private final PageElement dropdownValue = this.find(By.className((String)"filterable-tabs__single-value"));
    @ElementBy(className="filterable-tabs__menu-list")
    private PageElement dropdownMenu;

    public RepositorySelector(@Nonnull PageElement container) {
        super(container);
    }

    public List<Value> getResults() {
        return (List)this.dropdownMenu.findAll(By.className((String)"repository-selector-option")).stream().map(ElementUtils.bind(this.pageBinder, Value.class, new Object[0])).collect(MoreCollectors.toImmutableList());
    }

    public Value getValue() {
        return (Value)this.pageBinder.bind(Value.class, new Object[]{this.dropdownValue});
    }

    public RepositorySelector open() {
        this.dropdownControl.click();
        Poller.waitUntilTrue((TimedQuery)this.isOpen());
        Poller.waitUntilFalse((TimedQuery)this.isLoading());
        return this;
    }

    public RepositorySelector selectValue(String projectName, String repoName) {
        this.open().getResults().stream().filter(value -> value.getProjectName().equals(projectName) && value.getRepositoryName().equals(repoName)).findFirst().get().click();
        return this;
    }

    private TimedCondition isLoading() {
        return this.dropdownSpinner.timed().isVisible();
    }

    private TimedCondition isOpen() {
        return this.dropdownMenu.timed().isVisible();
    }

    public static class Value
    extends AbstractElementPageObject {
        private final PageElement projectNameElement = this.find(By.className((String)"project-name"));
        private final PageElement repositoryNameElement = this.find(By.className((String)"repository-name"));

        public Value(@Nonnull PageElement container) {
            super(container);
        }

        public void click() {
            this.container.click();
        }

        public String getProjectName() {
            return this.projectNameElement.getText();
        }

        public String getRepositoryName() {
            return this.repositoryNameElement.getText();
        }
    }
}

