/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.setting.InternalSharedLob;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;

@Cacheable
@Entity
@Table(name="sta_user_settings")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalUserSettings {
    public static final String TABLE = "sta_user_settings";
    @Id
    @Column(name="id", nullable=false)
    private final int id;
    @JoinColumn(name="lob_id", foreignKey=@ForeignKey(name="fk_sta_user_settings_lob"), nullable=false)
    @OneToOne(cascade={CascadeType.MERGE}, fetch=FetchType.LAZY, optional=false)
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    private final InternalSharedLob settings;

    protected InternalUserSettings() {
        this.id = 0;
        this.settings = null;
    }

    private InternalUserSettings(Builder builder) {
        this.id = builder.id;
        this.settings = builder.settings.build();
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public InternalSharedLob getSettings() {
        return this.settings;
    }

    public static class Builder {
        private int id;
        private InternalSharedLob.Builder settings;

        public Builder() {
            this.settings = new InternalSharedLob.Builder();
        }

        public Builder(@Nonnull InternalUserSettings userSettings) {
            Preconditions.checkNotNull((Object)userSettings, (Object)"userSettings");
            this.id = userSettings.getId();
            this.settings = new InternalSharedLob.Builder(userSettings.getSettings());
        }

        @Nonnull
        public InternalUserSettings build() {
            Preconditions.checkState((this.id != 0 ? 1 : 0) != 0, (Object)"No user ID is set. The user must be provided");
            return new InternalUserSettings(this);
        }

        @Nonnull
        public Builder user(@Nonnull InternalApplicationUser value) {
            this.id = ((InternalApplicationUser)Preconditions.checkNotNull((Object)value, (Object)"user")).getId();
            return this;
        }

        @Nonnull
        public Builder settings(@Nonnull InternalSharedLob value) {
            this.settings = new InternalSharedLob.Builder(value);
            return this;
        }

        @Nonnull
        public Builder settings(@Nonnull String value) {
            this.settings.data(value);
            return this;
        }
    }
}

