/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalGrantedPermissionVisitor;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.TableGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public abstract class InternalGrantedPermission {
    private static final String ID_GEN = "grantedPermIdGenerator";
    @TableGenerator(name="grantedPermIdGenerator", table="id_sequence", pkColumnValue="granted_permission", allocationSize=10)
    @Id
    @GeneratedValue(generator="grantedPermIdGenerator", strategy=GenerationType.TABLE)
    private final Long id;
    @Column(name="perm_id", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.permission.Permission")})
    private final Permission permission;
    @Column(name="group_name")
    @OptionalString(size=255)
    private final String group;
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalApplicationUser user;

    protected InternalGrantedPermission() {
        this.id = null;
        this.permission = null;
        this.group = null;
        this.user = null;
    }

    protected InternalGrantedPermission(Long id, Permission permission, String group, InternalApplicationUser user) {
        this.id = id;
        this.permission = permission;
        this.group = group == null ? null : IdentifierUtils.toLowerCase((String)group);
        this.user = user;
    }

    public abstract void accept(@Nonnull InternalGrantedPermissionVisitor var1);

    public Long getId() {
        return this.id;
    }

    public String getGroup() {
        return this.group;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public InternalApplicationUser getUser() {
        return this.user;
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        protected String group;
        protected Long id;
        protected Permission permission;
        protected InternalApplicationUser user;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(InternalGrantedPermission source) {
            this.group = source.getGroup();
            this.id = source.getId();
            this.permission = source.getPermission();
            this.user = source.getUser();
        }

        public B group(String group) {
            this.group = group;
            return this.self();
        }

        public B id(long id) {
            this.id = id;
            return this.self();
        }

        public B permission(Permission permission) {
            this.permission = permission;
            return this.self();
        }

        public B user(InternalApplicationUser user) {
            this.user = user;
            return this.self();
        }

        protected abstract B self();
    }
}

