/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.SimpleMinimalRef;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Embeddable
public class InternalRefChange
implements RefChange {
    public static final Function<RefChange, InternalRefChange> TRANSFORM_STRICT = change -> {
        if (change == null || change.getType() == null || change.getRef() == null || StringUtils.isBlank((CharSequence)change.getFromHash()) || change.getFromHash().length() != 40 || StringUtils.isBlank((CharSequence)change.getToHash()) || change.getToHash().length() != 40 || StringUtils.isBlank((CharSequence)change.getRef().getId())) {
            return null;
        }
        return new InternalRefChange((RefChange)change);
    };
    public static final Function<RefChange, InternalRefChange> TRANSFORM_TOLERANT = change -> {
        if (change == null || change.getType() == null || change.getRef() == null || StringUtils.isBlank((CharSequence)change.getRef().getId())) {
            return null;
        }
        return new InternalRefChange((RefChange)change);
    };
    @Column(name="from_hash", length=40)
    @OptionalString
    private final String fromHash;
    @Column(name="ref_id", nullable=false, length=1024)
    @RequiredString(size=1024)
    private final String refId;
    @Column(name="to_hash", length=40)
    @OptionalString
    private final String toHash;
    @Column(name="change_type", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.repository.RefChangeType")})
    private final RefChangeType type;

    protected InternalRefChange() {
        this.toHash = null;
        this.refId = null;
        this.fromHash = null;
        this.type = null;
    }

    private InternalRefChange(RefChange change) {
        this.fromHash = change.getFromHash();
        this.refId = change.getRef().getId();
        this.toHash = change.getToHash();
        this.type = change.getType();
    }

    @Nonnull
    public String getFromHash() {
        return this.fromHash;
    }

    @Nonnull
    public String getRefId() {
        return this.refId;
    }

    @Nonnull
    public MinimalRef getRef() {
        return ((SimpleMinimalRef.Builder)((SimpleMinimalRef.Builder)new SimpleMinimalRef.Builder().id(this.refId)).displayId(this.refId)).type((RefType)(this.refId.startsWith("refs/tags/") ? StandardRefType.TAG : StandardRefType.BRANCH)).build();
    }

    @Nonnull
    public String getToHash() {
        return this.toHash;
    }

    @Nonnull
    public RefChangeType getType() {
        return this.type;
    }
}

