/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.entity.InternalAbstractEntity;
import com.atlassian.stash.internal.repository.InternalRefChange;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.Hibernate;

@Entity
@Table(name="sta_pr_rescope_request", indexes={@Index(name="idx_sta_pr_rescope_req_repo", columnList="repo_id")})
@TableGenerator(allocationSize=43, pkColumnValue="sta_pr_rescope_request", name="entityIdGenerator", table="id_sequence")
public class InternalRescopeRequest
extends InternalAbstractEntity
implements Initializable,
Comparable<InternalRescopeRequest> {
    public static final Function<InternalRescopeRequest, Long> TO_ID = InternalAbstractEntity::getId;
    static final String TABLE = "sta_pr_rescope_request";
    @CollectionTable(name="sta_pr_rescope_request_change", joinColumns={@JoinColumn(name="request_id", nullable=false)})
    @ElementCollection(targetClass=InternalRefChange.class)
    private Set<RefChange> changes;
    @Column(name="created_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date createdDate;
    @JoinColumn(name="repo_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_pr_rescope_req_repo"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalRepository repository;
    @JoinColumn(name="user_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_pr_rescope_req_user"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalApplicationUser user;

    protected InternalRescopeRequest() {
        this.createdDate = null;
        this.changes = null;
        this.repository = null;
        this.user = null;
    }

    public InternalRescopeRequest(Builder builder) {
        super(builder);
        this.createdDate = builder.createdDate;
        this.changes = builder.refChanges;
        this.repository = builder.repository;
        this.user = builder.user;
    }

    @Override
    public int compareTo(@Nonnull InternalRescopeRequest o) {
        return this.createdDate.compareTo(o.createdDate);
    }

    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @Nonnull
    public Set<RefChange> getChanges() {
        return this.changes;
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Nonnull
    public InternalApplicationUser getUser() {
        return this.user;
    }

    @Override
    public void initialize() {
        this.repository = HibernateUtils.initialize(this.getRepository());
        this.user = HibernateUtils.initialize(this.getUser());
        Hibernate.initialize(this.changes);
    }

    public static class Builder
    extends InternalAbstractEntity.AbstractEntityBuilder<Builder, InternalRescopeRequest> {
        private final Set<RefChange> refChanges;
        private final InternalRepository repository;
        private final InternalApplicationUser user;
        private Date createdDate;

        public Builder(@Nonnull InternalRescopeRequest request) {
            super(request);
            this.createdDate = Objects.requireNonNull(request.getCreatedDate(), "request.createdDate");
            this.refChanges = Sets.newHashSet((Iterable)Objects.requireNonNull(request.getChanges(), "request.changes"));
            this.repository = Objects.requireNonNull(request.getRepository(), "request.repository");
            this.user = Objects.requireNonNull(request.getUser(), "request.user");
        }

        public Builder(@Nonnull InternalRepository repository, @Nonnull InternalApplicationUser user) {
            this.createdDate = new Date();
            this.repository = Objects.requireNonNull(repository, "repository");
            this.user = Objects.requireNonNull(user, "user");
            this.refChanges = Sets.newHashSet();
        }

        @Override
        @Nonnull
        public InternalRescopeRequest build() {
            return new InternalRescopeRequest(this);
        }

        @Nonnull
        public Builder changes(@Nonnull Iterable<RefChange> value) {
            Preconditions.checkNotNull(value, (Object)"changes");
            Builder.addIf(Objects::nonNull, this.refChanges, (Iterable)Iterables.transform(value, InternalRefChange.TRANSFORM_TOLERANT));
            return this.self();
        }

        @Nonnull
        public Builder createdDate(@Nonnull Date value) {
            this.createdDate = (Date)Preconditions.checkNotNull((Object)value, (Object)"createdDate");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

