/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.repository.InternalRepository;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Embeddable
public class InternalPullRequestRef
implements Initializable,
PullRequestRef {
    @Column(name="branch_name", nullable=false, length=1024)
    @RequiredString(size=1024)
    private final String displayId;
    @Column(name="hash", nullable=false, length=40)
    @RequiredString(minimumSize=40, size=40)
    private final String hash;
    @Column(name="branch_fqn", nullable=false, length=1024)
    @RequiredString(size=1024)
    private final String id;
    @JoinColumn(name="repository_id", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalRepository repository;

    protected InternalPullRequestRef() {
        this.id = null;
        this.hash = null;
        this.displayId = null;
    }

    private InternalPullRequestRef(@Nonnull Builder builder) {
        this.displayId = builder.displayId;
        this.hash = builder.hash;
        this.id = builder.id;
        this.repository = builder.repository;
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Nonnull
    public String getDisplayId() {
        return this.displayId;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getLatestCommit() {
        return this.hash;
    }

    @Nonnull
    public RefType getType() {
        return StandardRefType.BRANCH;
    }

    @Override
    public void initialize() {
        this.repository = HibernateUtils.initialize(this.getRepository());
    }

    public String toString() {
        return this.getRepository().getProject().getKey() + "/" + this.getRepository().getSlug() + ":" + this.getId();
    }

    public static class Builder
    extends BuilderSupport {
        private String displayId;
        private String hash;
        private String id;
        private InternalRepository repository;

        public Builder() {
        }

        public Builder(@Nonnull InternalPullRequestRef ref) {
            this.displayId = Objects.requireNonNull(ref, "ref").getDisplayId();
            this.hash = ref.getLatestCommit();
            this.id = ref.getId();
            this.repository = ref.getRepository();
        }

        @Nonnull
        public InternalPullRequestRef build() {
            return new InternalPullRequestRef(this);
        }

        @Nonnull
        public Builder displayId(String value) {
            this.displayId = Builder.checkNotBlank((String)value, (String)"displayId");
            return this;
        }

        @Nonnull
        public Builder hash(String value) {
            this.hash = Builder.checkNotBlank((String)value, (String)"hash");
            return this;
        }

        @Nonnull
        public Builder id(String value) {
            this.id = Builder.checkNotBlank((String)value, (String)"id");
            return this;
        }

        @Nonnull
        public Builder ref(@Nonnull Ref value) {
            this.displayId = Objects.requireNonNull(value, "ref").getDisplayId();
            this.hash = value.getLatestCommit();
            this.id = value.getId();
            return this;
        }

        @Nonnull
        public Builder repository(@Nonnull InternalRepository value) {
            this.repository = Objects.requireNonNull(value, "repository");
            return this;
        }
    }
}

