/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.project;

import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.StringUtils;

@DiscriminatorValue(value="1")
@Entity
@PrimaryKeyJoinColumn(name="project_id", referencedColumnName="id")
@Table(name="sta_personal_project", uniqueConstraints={@UniqueConstraint(name="uq_sta_personal_project_owner", columnNames={"owner_id"})})
public class InternalPersonalProject
extends InternalProject
implements PersonalProject {
    public static final String TABLE = "sta_personal_project";
    @JoinColumn(name="owner_id", nullable=false, unique=true, foreignKey=@ForeignKey(name="fk_sta_personal_project_owner"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalApplicationUser owner;

    protected InternalPersonalProject() {
    }

    private InternalPersonalProject(Integer id, String namespace, String key, InternalNormalUser owner) {
        super(id, namespace, key, key, null, ProjectType.PERSONAL);
        this.owner = owner;
    }

    public <T> T accept(@Nonnull ProjectVisitor<T> visitor) {
        return (T)visitor.visit((PersonalProject)this);
    }

    public Builder copy() {
        return new Builder(this);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.getOwner().getDisplayName();
    }

    @Nonnull
    public InternalNormalUser getOwner() {
        return HibernateUtils.cast(this.owner, InternalNormalUser.class);
    }

    @Override
    public void initialize() {
        this.owner = HibernateUtils.initialize(this.getOwner());
    }

    public boolean isPublic() {
        return false;
    }

    public static String createPersonalProjectKey(@Nonnull ApplicationUser user) {
        return InternalPersonalProject.createPersonalProjectKey(user.getSlug());
    }

    public static String createPersonalProjectKey(@Nonnull String slug) {
        return "~" + slug;
    }

    public static String getPersonalProjectOwner(@Nonnull String projectKey) {
        return InternalPersonalProject.isPersonalProjectKey(projectKey) ? IdentifierUtils.toLowerCase((String)projectKey.substring(1)) : null;
    }

    public static boolean isPersonalProjectKey(@Nonnull String projectKey) {
        return StringUtils.startsWith((CharSequence)projectKey, (CharSequence)"~");
    }

    public static class Builder
    extends InternalProject.AbstractBuilder<Builder> {
        private String key;
        private InternalNormalUser owner;

        public Builder() {
        }

        public Builder(@Nonnull InternalPersonalProject project) {
            super(project);
            this.key = project.getKey();
            this.owner = project.getOwner();
        }

        @Nonnull
        public InternalPersonalProject build() {
            Preconditions.checkState((this.owner != null ? 1 : 0) != 0, (Object)"The personal project's owner is required");
            return new InternalPersonalProject(this.id, this.namespace, this.key, this.owner);
        }

        @Nonnull
        public Builder owner(@Nonnull InternalNormalUser value) {
            this.owner = (InternalNormalUser)Preconditions.checkNotNull((Object)value, (Object)"owner");
            this.key = InternalPersonalProject.createPersonalProjectKey(value);
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

