/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.bitbucket.idx.IndexedCommit;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.idx.InternalCommitAttribute;
import com.atlassian.stash.internal.idx.InternalRepositoryMembership;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Immutable;

@Entity
@Table(name="changeset")
@Immutable
public class InternalIndexedCommit
implements IndexedCommit,
Initializable {
    @Id
    @Column(name="id")
    @RequiredString(size=40)
    private final String id;
    @Column(name="author_timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date authorTimestamp;
    @OneToMany(mappedBy="commit", cascade={CascadeType.REMOVE})
    @OrderBy(value="repository.id")
    private Set<InternalRepositoryMembership> repositoryMemberships;
    @ElementCollection
    @CollectionTable(name="cs_attribute", joinColumns={@JoinColumn(name="cs_id")})
    private final Set<InternalCommitAttribute> attributes;

    protected InternalIndexedCommit() {
        this.id = null;
        this.authorTimestamp = null;
        this.attributes = null;
    }

    public InternalIndexedCommit(String id, Date authorTimestamp) {
        this.id = id;
        this.authorTimestamp = authorTimestamp;
        this.attributes = new HashSet<InternalCommitAttribute>();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalIndexedCommit) {
            InternalIndexedCommit that = (InternalIndexedCommit)o;
            return Objects.equals(this.getId(), that.getId());
        }
        return false;
    }

    public boolean addAttribute(InternalCommitAttribute attribute) {
        return this.attributes.add(attribute);
    }

    public Set<InternalCommitAttribute> getAttributes() {
        return Collections.unmodifiableSet(this.attributes);
    }

    @Nonnull
    public Date getAuthorTimestamp() {
        return this.authorTimestamp;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public Set<InternalRepositoryMembership> getRepositoryMemberships() {
        return this.repositoryMemberships;
    }

    @Nonnull
    public Set<Repository> getRepositories() {
        Set<InternalRepositoryMembership> repositoryMemberships = this.getRepositoryMemberships();
        if (repositoryMemberships == null) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf((Collection)Collections2.transform(repositoryMemberships, (Function)new Function<InternalRepositoryMembership, Repository>(){

            public InternalRepository apply(InternalRepositoryMembership membership) {
                return membership.getRepository();
            }
        }));
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    @Override
    public void initialize() {
        this.repositoryMemberships = HibernateUtils.initializeSet(this.getRepositoryMemberships());
    }

    public boolean removeAttribute(InternalCommitAttribute attribute) {
        return this.attributes.remove(attribute);
    }

    public String toString() {
        return this.id;
    }
}

