/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.validation;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.validation.ProjectNameUnique;
import com.atlassian.stash.internal.validation.ProjectValidator;
import com.google.common.base.Preconditions;
import javax.validation.ConstraintValidatorContext;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectNameValidator
implements ProjectValidator<ProjectNameUnique> {
    private String message;
    private ProjectService projectService;
    private SecurityService securityService;

    public void initialize(ProjectNameUnique annotation) {
        this.message = ((ProjectNameUnique)Preconditions.checkNotNull((Object)annotation, (Object)"annotation")).message();
    }

    public boolean isValid(InternalProject value, ConstraintValidatorContext context) {
        if (value == null || this.projectService == null || this.securityService == null) {
            return true;
        }
        if (value.getName() == null) {
            return false;
        }
        Project found = (Project)this.securityService.withPermission(Permission.PROJECT_VIEW, "validate project name uniqueness").call(() -> this.projectService.getByName(value.getName()));
        if (found == null || found.getId() == value.getId()) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        ConstraintValidatorContext.ConstraintViolationBuilder builder = context.buildConstraintViolationWithTemplate(this.message);
        builder.addNode("name");
        builder.addConstraintViolation();
        return false;
    }

    @Override
    @Autowired
    public void setProjectService(ProjectService projectService) {
        this.projectService = projectService;
    }

    @Override
    @Autowired
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }
}

