/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.internal.user.InternalGrantedPermissionVisitor;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="sta_project_permission", indexes={@Index(name="idx_project_permission_user", columnList="user_id"), @Index(name="idx_project_permission_group", columnList="group_name")})
public class InternalProjectPermission
extends InternalGrantedPermission {
    static final String TABLE = "sta_project_permission";
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalProject project;

    protected InternalProjectPermission() {
        this.project = null;
    }

    @Override
    public void accept(@Nonnull InternalGrantedPermissionVisitor visitor) {
        visitor.visit(this);
    }

    private InternalProjectPermission(Long id, Permission permission, InternalProject project, String group, InternalApplicationUser user) {
        super(id, permission, group, user);
        this.project = project;
    }

    @Nonnull
    public InternalProject getProject() {
        return this.project;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalProjectPermission) {
            InternalProjectPermission that = (InternalProjectPermission)o;
            return Objects.equals(this.getPermission(), that.getPermission()) && Objects.equals(this.getGroup(), that.getGroup()) && Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getProject(), that.getProject()) && Objects.equals(this.getUser(), that.getUser());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getPermission(), this.getGroup(), this.getId(), this.getProject(), this.getUser());
    }

    public static final class Builder
    extends InternalGrantedPermission.AbstractBuilder<Builder> {
        private InternalProject project;

        public Builder() {
        }

        public Builder(InternalProjectPermission source) {
            super(source);
            this.project = source.getProject();
        }

        public InternalProjectPermission build() {
            return new InternalProjectPermission(this.id, this.permission, this.project, this.group, this.user);
        }

        public Builder project(InternalProject project) {
            this.project = project;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

