/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserEquality;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InternalDetailedUser
implements DetailedUser {
    private final InternalApplicationUser delegate;
    private final String directoryName;
    private final boolean deletable;
    private final long lastAuthenticationTimestamp;
    private final boolean mutableDetails;
    private final boolean mutableGroups;

    private InternalDetailedUser(Builder builder) {
        this.delegate = builder.delegate;
        this.deletable = builder.deletable;
        this.directoryName = builder.directoryName;
        this.lastAuthenticationTimestamp = builder.lastAuthenticationTimestamp == null ? -1L : builder.lastAuthenticationTimestamp.getTime();
        this.mutableDetails = builder.mutableDetails;
        this.mutableGroups = builder.mutableGroups;
    }

    public <T> T accept(@Nonnull ApplicationUserVisitor<T> visitor) {
        return (T)visitor.visit((DetailedUser)this);
    }

    public boolean equals(Object o) {
        return ApplicationUserEquality.equals((ApplicationUser)this, (Object)o);
    }

    public InternalApplicationUser getDelegate() {
        return this.delegate;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    @Nonnull
    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    public String getEmailAddress() {
        return this.delegate.getEmailAddress();
    }

    public int getId() {
        return this.delegate.getId();
    }

    public Date getLastAuthenticationTimestamp() {
        return this.lastAuthenticationTimestamp == -1L ? null : new Date(this.lastAuthenticationTimestamp);
    }

    @Nonnull
    public String getName() {
        return this.delegate.getName();
    }

    @Nonnull
    public String getSlug() {
        return this.delegate.getSlug();
    }

    @Nonnull
    public UserType getType() {
        return this.delegate.getType();
    }

    public int hashCode() {
        return ApplicationUserEquality.hashCode((ApplicationUser)this);
    }

    public boolean isActive() {
        return this.delegate.isActive();
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public boolean isMutableDetails() {
        return this.mutableDetails;
    }

    public boolean isMutableGroups() {
        return this.mutableGroups;
    }

    public static class Builder {
        private InternalApplicationUser delegate;
        private boolean deletable;
        private String directoryName;
        private Date lastAuthenticationTimestamp;
        private boolean mutableDetails;
        private boolean mutableGroups;

        public Builder(InternalApplicationUser user) {
            this.delegate = (InternalApplicationUser)Preconditions.checkNotNull((Object)user, (Object)"user");
        }

        public Builder(InternalDetailedUser user) {
            this.delegate = ((InternalDetailedUser)Preconditions.checkNotNull((Object)user, (Object)"user")).delegate;
            this.directoryName = user.getDirectoryName();
            this.mutableDetails = user.isMutableDetails();
            this.mutableGroups = user.isMutableGroups();
        }

        @Nonnull
        public InternalDetailedUser build() {
            return new InternalDetailedUser(this);
        }

        @Nonnull
        public Builder deletable(boolean value) {
            this.deletable = value;
            return this;
        }

        @Nonnull
        public Builder directoryName(String value) {
            this.directoryName = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }

        @Nonnull
        public Builder lastAuthenticationTimestamp(@Nullable Date value) {
            this.lastAuthenticationTimestamp = value;
            return this;
        }

        @Nonnull
        public Builder mutableDetails(boolean value) {
            this.mutableDetails = value;
            return this;
        }

        @Nonnull
        public Builder mutableGroups(boolean value) {
            this.mutableGroups = value;
            return this;
        }
    }
}

