/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.setting;

import com.atlassian.bitbucket.setting.Settings;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class MapSettings
implements Settings {
    private final Map<String, Object> values;

    MapSettings(Map<String, Object> values) {
        this.values = ImmutableMap.copyOf(values);
    }

    private <T> T get(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        return (T)this.values.get(key);
    }

    public String getString(@Nonnull String key) {
        return (String)this.get(key);
    }

    @Nonnull
    public String getString(@Nonnull String key, @Nonnull String defaultValue) {
        return (String)MoreObjects.firstNonNull((Object)this.getString(key), (Object)defaultValue);
    }

    public Boolean getBoolean(@Nonnull String key) {
        try {
            return (Boolean)this.get(key);
        }
        catch (ClassCastException e) {
            return Boolean.parseBoolean(this.getString(key));
        }
    }

    public boolean getBoolean(@Nonnull String key, boolean defaultValue) {
        return (Boolean)MoreObjects.firstNonNull((Object)this.getBoolean(key), (Object)defaultValue);
    }

    private Number getNumber(String key) {
        return (Number)this.get(key);
    }

    public Integer getInt(@Nonnull String key) {
        try {
            Number value = this.getNumber(key);
            return value != null ? Integer.valueOf(value.intValue()) : null;
        }
        catch (ClassCastException e) {
            return Integer.parseInt(this.getString(key));
        }
    }

    public int getInt(@Nonnull String key, int defaultValue) {
        return (Integer)MoreObjects.firstNonNull((Object)this.getInt(key), (Object)defaultValue);
    }

    public Long getLong(@Nonnull String key) {
        try {
            Number value = this.getNumber(key);
            return value != null ? Long.valueOf(value.longValue()) : null;
        }
        catch (ClassCastException e) {
            return Long.parseLong(this.getString(key));
        }
    }

    public long getLong(@Nonnull String key, long defaultValue) {
        return (Long)MoreObjects.firstNonNull((Object)this.getLong(key), (Object)defaultValue);
    }

    public Double getDouble(@Nonnull String key) {
        try {
            Number value = this.getNumber(key);
            return value != null ? Double.valueOf(value.doubleValue()) : null;
        }
        catch (ClassCastException e) {
            return Double.parseDouble(this.getString(key));
        }
    }

    public double getDouble(@Nonnull String key, double defaultValue) {
        return (Double)MoreObjects.firstNonNull((Object)this.getDouble(key), (Object)defaultValue);
    }

    public Map<String, Object> asMap() {
        return this.values;
    }
}

