/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.bitbucket.scm.AvailableScm;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class SimpleAvailableScm
implements AvailableScm {
    private final String id;
    private final String name;

    private SimpleAvailableScm(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public static class Builder
    extends BuilderSupport {
        private final String id;
        private String name;

        public Builder(@Nonnull String id) {
            this.id = Builder.checkNotBlank((String)id, (String)"id");
        }

        @Nonnull
        public SimpleAvailableScm build() {
            Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"An SCM name is required");
            return new SimpleAvailableScm(this);
        }

        @Nonnull
        public Builder name(@Nonnull String value) {
            this.name = Builder.checkNotBlank((String)value, (String)"name");
            return this;
        }
    }
}

