/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.validation.ConstraintNature;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.bitbucket.validation.groups.Create;
import com.atlassian.bitbucket.validation.groups.Update;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.validation.RepositoryUniqueness;
import com.google.common.base.Preconditions;
import java.text.Normalizer;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Cacheable
@Entity
@RepositoryUniqueness(groups={Create.class, Update.class}, payload={ConstraintNature.Conflict.class})
@Table(name="repository", indexes={@Index(name="idx_repository_hierarchy_id", columnList="hierarchy_id"), @Index(name="idx_repository_project_id", columnList="project_id"), @Index(name="idx_repository_state", columnList="state")}, uniqueConstraints={@UniqueConstraint(name="uk_slug_project_id", columnNames={"slug", "project_id"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalRepository
implements Initializable,
Repository {
    public static final String TABLE = "repository";
    public static final int TOKEN_LENGTH = 20;
    private static final String ID_GEN = "repoIdGenerator";
    @Column(name="is_forkable", nullable=false)
    private final boolean forkable;
    @Column(name="hierarchy_id", length=20, nullable=false, updatable=false)
    @RequiredString(size=20)
    private final String hierarchyId;
    @TableGenerator(name="repoIdGenerator", table="id_sequence", pkColumnValue="repository", allocationSize=10)
    @Id
    @GeneratedValue(generator="repoIdGenerator", strategy=GenerationType.TABLE)
    private final int id;
    @Column(name="name")
    private final String name;
    @OneToOne(fetch=FetchType.LAZY, targetEntity=InternalRepository.class)
    @JoinTable(name="sta_repo_origin", joinColumns={@JoinColumn(name="repository_id", nullable=false)}, inverseJoinColumns={@JoinColumn(name="origin_id", nullable=false)})
    private final InternalRepository origin;
    @ManyToOne(fetch=FetchType.LAZY, optional=false, targetEntity=InternalProject.class)
    @JoinColumn(name="project_id", nullable=false)
    private InternalProject project;
    @Column(name="is_public", nullable=false)
    private final boolean publiclyAccessible;
    @Column(name="scm_id", nullable=false, updatable=false)
    private final String scmId;
    @Column(name="slug")
    private final String slug;
    @Column(name="state", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.repository.Repository$State")})
    private final Repository.State state;

    protected InternalRepository() {
        this.forkable = true;
        this.hierarchyId = null;
        this.id = 0;
        this.name = null;
        this.origin = null;
        this.publiclyAccessible = false;
        this.scmId = null;
        this.slug = null;
        this.state = null;
    }

    private InternalRepository(Integer id, InternalProject project, String slug, String name, String scmId, String hierarchyId, InternalRepository origin, Repository.State state, boolean forkable, boolean publiclyAccessible) {
        this.forkable = forkable;
        this.hierarchyId = hierarchyId;
        this.id = id;
        this.name = name;
        this.origin = origin;
        this.project = project;
        this.publiclyAccessible = publiclyAccessible;
        this.scmId = scmId;
        this.slug = slug == null ? InternalRepository.slugify(name) : slug;
        this.state = state == null ? Repository.State.INITIALISING : state;
    }

    public Builder copy() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalRepository) {
            InternalRepository that = (InternalRepository)o;
            return Objects.equals(this.getId(), that.getId());
        }
        return false;
    }

    @Nonnull
    public String getHierarchyId() {
        return this.hierarchyId;
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public InternalRepository getOrigin() {
        return this.origin;
    }

    @Nonnull
    public InternalProject getProject() {
        return this.project;
    }

    @Nonnull
    public String getScmId() {
        return this.scmId;
    }

    @Nonnull
    public String getSlug() {
        return this.slug;
    }

    @Nonnull
    public Repository.State getState() {
        return this.state;
    }

    @Nonnull
    public String getStatusMessage() {
        return this.getState().getStatusMessage();
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    @Override
    public void initialize() {
        this.project = HibernateUtils.initialize(this.getProject());
        HibernateUtils.initialize(this.getOrigin());
    }

    public boolean isFork() {
        return this.getOrigin() != null;
    }

    public boolean isForkable() {
        return this.forkable;
    }

    public boolean isPublic() {
        return this.publiclyAccessible;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.getProject().getNamespace() != null) {
            builder.append(this.getProject().getNamespace()).append('/');
        }
        return builder.append(this.getProject().getKey()).append('/').append(this.getSlug()).append('[').append(this.getId()).append(']').toString();
    }

    public static String slugify(String name) {
        return Normalizer.normalize(name, Normalizer.Form.NFKD).replaceAll("[^\\p{InBasicLatin}]+", "").replaceAll("[^a-zA-Z\\-_0-9\\.]+", "-").toLowerCase(Locale.US);
    }

    public static class Builder {
        private boolean forkable;
        private String hierarchyId;
        private int id;
        private String name;
        private InternalRepository origin;
        private InternalProject project;
        private boolean publiclyAccessible;
        private String scmId;
        private String slug;
        private Repository.State state;

        public Builder() {
            this.forkable = true;
            this.id = 0;
        }

        public Builder(@Nonnull InternalRepository repository) {
            this.forkable = ((InternalRepository)Preconditions.checkNotNull((Object)repository, (Object)InternalRepository.TABLE)).isForkable();
            this.hierarchyId = repository.getHierarchyId();
            this.id = repository.getId();
            this.name = repository.getName();
            this.origin = repository.getOrigin();
            this.project = repository.getProject();
            this.publiclyAccessible = repository.isPublic();
            this.scmId = repository.getScmId();
            this.slug = repository.getSlug();
            this.state = repository.getState();
        }

        @Nonnull
        public InternalRepository build() {
            return new InternalRepository(this.id, this.project, this.slug, this.name, this.scmId, this.hierarchyId, this.origin, this.state, this.forkable, this.publiclyAccessible);
        }

        @Nonnull
        public Builder forkable(boolean value) {
            this.forkable = value;
            return this;
        }

        @Nonnull
        public Builder hierarchyId(@Nonnull String value) {
            Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)value, (Object)"value")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank hierarchy ID is required");
            this.hierarchyId = value;
            return this;
        }

        @Nonnull
        public Builder id(int value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public Builder name(@Nonnull String value) {
            Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)value, (Object)"value")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank name is required");
            this.name = value;
            this.slug = InternalRepository.slugify(value);
            return this;
        }

        @Nonnull
        public Builder origin(@Nullable InternalRepository value) {
            this.origin = value;
            return this;
        }

        @Nonnull
        public Builder project(@Nonnull InternalProject value) {
            this.project = (InternalProject)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }

        @Nonnull
        public Builder publiclyAccessible(boolean value) {
            this.publiclyAccessible = value;
            return this;
        }

        @Nonnull
        public Builder scmId(@Nonnull String value) {
            Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)value, (Object)"value")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank SCM ID is required");
            this.scmId = value;
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull Repository.State value) {
            this.state = (Repository.State)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }
    }
}

