/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestDiffCommentAnchor;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.comment.InternalDiffCommentAnchor;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;

@DiscriminatorValue(value="1")
@Entity
@PrimaryKeyJoinColumn(name="anchor_id", referencedColumnName="id")
@Table(name="sta_pr_diff_comment_anchor", indexes={@Index(name="idx_sta_pr_diff_com_anc_pr", columnList="pr_id, is_orphaned")})
public class InternalPullRequestDiffCommentAnchor
extends InternalDiffCommentAnchor
implements PullRequestDiffCommentAnchor {
    public static final String TABLE = "sta_pr_diff_comment_anchor";
    @Column(name="is_orphaned", nullable=false)
    private final boolean orphaned;
    @JoinColumn(name="pr_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_pr_diff_com_anc_pr"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalPullRequest pullRequest;

    protected InternalPullRequestDiffCommentAnchor() {
        this.orphaned = false;
        this.pullRequest = null;
    }

    private InternalPullRequestDiffCommentAnchor(Builder builder) {
        super(builder);
        this.orphaned = builder.orphaned;
        this.pullRequest = builder.pullRequest;
    }

    @Nonnull
    public InternalPullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Override
    public void initialize() {
        super.initialize();
        HibernateUtils.initialize(this.getPullRequest());
    }

    public boolean isOrphaned() {
        return this.orphaned;
    }

    public static class Builder
    extends InternalDiffCommentAnchor.AbstractBuilder<Builder, InternalPullRequestDiffCommentAnchor> {
        private final InternalPullRequest pullRequest;
        private boolean orphaned;

        public Builder(@Nonnull InternalPullRequest pullRequest) {
            this.pullRequest = (InternalPullRequest)Preconditions.checkNotNull((Object)pullRequest, (Object)"pullRequest");
        }

        public Builder(@Nonnull InternalPullRequestDiffCommentAnchor anchor) {
            super(anchor);
            this.orphaned = anchor.isOrphaned();
            this.pullRequest = anchor.getPullRequest();
        }

        @Override
        @Nonnull
        public InternalPullRequestDiffCommentAnchor build() {
            return new InternalPullRequestDiffCommentAnchor(this);
        }

        @Nonnull
        public Builder orphaned(boolean value) {
            this.orphaned = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

