/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.group;

import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.entity.InternalAbstractEntity;
import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="sta_deleted_group", indexes={@Index(name="idx_sta_deleted_group_ts", columnList="deleted_timestamp")}, uniqueConstraints={@UniqueConstraint(name="uq_sta_deleted_group_name", columnNames={"name"})})
@TableGenerator(allocationSize=20, pkColumnValue="sta_deleted_group", name="entityIdGenerator", table="id_sequence")
public class InternalDeletedGroup
extends InternalAbstractEntity {
    public static final String TABLE = "sta_deleted_group";
    public static final int MAX_NAME_LENGTH = 255;
    @Column(name="name", nullable=false, updatable=false)
    @RequiredString(size=255)
    private final String name;
    @Column(name="deleted_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date deletedDate;

    protected InternalDeletedGroup() {
        this.name = null;
        this.deletedDate = null;
    }

    protected InternalDeletedGroup(@Nonnull Builder builder) {
        super(builder);
        this.name = builder.name;
        this.deletedDate = new Date(builder.deletedDate.getTime());
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Date getDeletedDate() {
        return this.deletedDate;
    }

    public static class Builder
    extends InternalAbstractEntity.AbstractEntityBuilder<Builder, InternalDeletedGroup> {
        private String name;
        private Date deletedDate;

        public Builder() {
        }

        public Builder(@Nonnull InternalDeletedGroup deletedGroup) {
            super(deletedGroup);
            this.name = ((InternalDeletedGroup)Preconditions.checkNotNull((Object)deletedGroup, (Object)"deletedGroup")).getName();
            this.deletedDate = deletedGroup.getDeletedDate();
        }

        @Override
        @Nonnull
        public InternalDeletedGroup build() {
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"The group name is required");
            Preconditions.checkState((this.deletedDate != null ? 1 : 0) != 0, (Object)"The deleted date is required");
            return new InternalDeletedGroup(this);
        }

        @Nonnull
        public Builder name(@Nonnull String value) {
            this.name = IdentifierUtils.toLowerCase((String)Builder.checkNotBlank((String)value, (String)"name"));
            return this;
        }

        @Nonnull
        public Builder deletedDate(@Nonnull Date value) {
            this.deletedDate = (Date)Preconditions.checkNotNull((Object)value, (Object)"deletedDate");
            return this;
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

