/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.entity;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
public abstract class InternalAbstractEntity {
    public static final String ID_GEN = "entityIdGenerator";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="entityIdGenerator", strategy=GenerationType.TABLE)
    private final long id;

    protected InternalAbstractEntity() {
        this.id = 0L;
    }

    protected InternalAbstractEntity(AbstractEntityBuilder<?, ?> builder) {
        this.id = ((AbstractEntityBuilder)builder).id;
    }

    public long getId() {
        return this.id;
    }

    protected static abstract class AbstractEntityBuilder<B extends AbstractEntityBuilder<B, E>, E extends InternalAbstractEntity>
    extends BuilderSupport {
        private long id;

        protected AbstractEntityBuilder() {
            this.id = 0L;
        }

        protected AbstractEntityBuilder(@Nonnull E entity) {
            this.id = ((InternalAbstractEntity)Preconditions.checkNotNull(entity, (Object)"entity")).getId();
        }

        @Nonnull
        public abstract E build();

        @Nonnull
        public B id(long value) {
            this.id = value;
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

