/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.bitbucket.comment.CommentableVisitor;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.commit.CommitDiscussionParticipant;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.bitbucket.watcher.WatchableVisitor;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionParticipant;
import com.atlassian.stash.internal.entity.InternalAbstractEntity;
import com.atlassian.stash.internal.participant.InternalParticipable;
import com.atlassian.stash.internal.participant.ParticipableVisitor;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.InternalWatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Where;

@Cacheable
@Entity
@Table(name="sta_cmt_discussion", indexes={@Index(name="idx_sta_cmt_disc_cmt", columnList="commit_id"), @Index(name="idx_sta_cmt_disc_repo", columnList="repository_id")}, uniqueConstraints={@UniqueConstraint(name="uq_sta_cmt_disc_repo_cmt", columnNames={"repository_id", "commit_id"})})
@TableGenerator(allocationSize=20, pkColumnValue="sta_cmt_discussion", name="entityIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Immutable
public class InternalCommitDiscussion
extends InternalAbstractEntity
implements CommitDiscussion,
Initializable,
InternalCommentable,
InternalParticipable<InternalCommitDiscussionParticipant>,
InternalWatchable {
    public static final String TABLE = "sta_cmt_discussion";
    @Column(name="commit_id", nullable=false, length=40)
    @RequiredString(minimumSize=40, size=40)
    private final String commitId;
    @Column(name="parent_id", nullable=false, length=40)
    @OptionalString(minimumSize=40, size=40)
    private final String parentId;
    @Column(name="parent_count", nullable=false)
    private final int parents;
    @OneToMany(mappedBy="discussion", targetEntity=InternalCommitDiscussionParticipant.class)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private final Set<CommitDiscussionParticipant> participants;
    @JoinColumn(name="repository_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_cmt_disc_repo"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalRepository repository;
    @JoinColumn(name="watchable_id", updatable=false)
    @OneToMany(targetEntity=InternalWatcher.class)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Where(clause="watchable_type = 2")
    private final Set<Watcher> watchers;

    protected InternalCommitDiscussion() {
        this.parentId = null;
        this.commitId = null;
        this.parents = 0;
        this.participants = Sets.newHashSet();
        this.watchers = Sets.newHashSet();
    }

    private InternalCommitDiscussion(Builder builder) {
        super(builder);
        this.commitId = builder.commitId;
        this.parentId = builder.parentId;
        this.parents = builder.parents;
        this.participants = Sets.newHashSet((Iterable)builder.participants);
        this.repository = builder.repository;
        this.watchers = Sets.newHashSet((Iterable)builder.watchers);
    }

    @Override
    public <T> T accept(@Nonnull CommentableVisitor<T> visitor) {
        return (T)visitor.visit((CommitDiscussion)this);
    }

    @Override
    public <T> T accept(@Nonnull ParticipableVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <T> T accept(@Nonnull WatchableVisitor<T> visitor) {
        return (T)visitor.visit((CommitDiscussion)this);
    }

    @Override
    public void addParticipant(@Nonnull InternalCommitDiscussionParticipant participant) {
        this.participants.add(participant);
    }

    @Override
    public void addWatcher(@Nonnull InternalWatcher watcher) {
        this.watchers.add(watcher);
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    public String getParentId() {
        return this.parentId;
    }

    @Nonnull
    public Set<CommitDiscussionParticipant> getParticipants() {
        return Collections.unmodifiableSet(this.participants);
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    @Nonnull
    public InternalRepository getScopeRepository() {
        return this.getRepository();
    }

    @Nonnull
    public Set<Watcher> getWatchers() {
        return Collections.unmodifiableSet(this.watchers);
    }

    public boolean isMerge() {
        return this.parents > 1;
    }

    @Override
    public void initialize() {
        this.repository = HibernateUtils.initialize(this.getRepository());
        Hibernate.initialize(this.getParticipants());
        Hibernate.initialize(this.getWatchers());
        for (CommitDiscussionParticipant participant : this.getParticipants()) {
            Hibernate.initialize((Object)participant);
            Hibernate.initialize((Object)participant.getUser());
        }
        for (Watcher watcher : this.getWatchers()) {
            Hibernate.initialize((Object)watcher);
            Hibernate.initialize((Object)watcher.getUser());
        }
    }

    @Override
    public void removeParticipant(@Nonnull InternalCommitDiscussionParticipant participant) {
        this.participants.remove(participant);
    }

    @Override
    public void removeWatcher(@Nonnull InternalWatcher watcher) {
        this.watchers.remove(watcher);
    }

    public static class Builder
    extends InternalAbstractEntity.AbstractEntityBuilder<Builder, InternalCommitDiscussion> {
        private final String commitId;
        private final Set<CommitDiscussionParticipant> participants;
        private final InternalRepository repository;
        private final Set<Watcher> watchers;
        private String parentId;
        private int parents;

        public Builder(@Nonnull InternalCommitDiscussion discussion) {
            super(discussion);
            this.commitId = Builder.checkNotBlank((String)discussion.getCommitId(), (String)"discussion.commitId");
            this.participants = Sets.newHashSet(discussion.getParticipants());
            this.repository = (InternalRepository)Preconditions.checkNotNull((Object)discussion.getRepository(), (Object)"discussion.repository");
            this.watchers = Sets.newHashSet(discussion.getWatchers());
        }

        public Builder(@Nonnull InternalRepository repository, @Nonnull String commitId) {
            this.commitId = Builder.checkNotBlank((String)commitId, (String)"commitId");
            this.repository = (InternalRepository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
            this.participants = Sets.newHashSet();
            this.watchers = Sets.newHashSet();
        }

        @Override
        @Nonnull
        public InternalCommitDiscussion build() {
            return new InternalCommitDiscussion(this);
        }

        @Nonnull
        public Builder parents(@Nullable Collection<? extends MinimalCommit> value) {
            if (value == null || value.isEmpty()) {
                this.parentId = null;
                this.parents = 0;
            } else {
                this.parentId = ((MinimalCommit)Iterables.getFirst(value, null)).getId();
                this.parents = value.size();
            }
            return this.self();
        }

        @Nonnull
        public Builder participant(@Nullable CommitDiscussionParticipant value) {
            return this.participants(value, new CommitDiscussionParticipant[0]);
        }

        @Nonnull
        public Builder participants(@Nullable Iterable<CommitDiscussionParticipant> values) {
            Builder.addIf(Objects::nonNull, this.participants, values);
            return this.self();
        }

        @Nonnull
        public Builder participants(@Nullable CommitDiscussionParticipant value, CommitDiscussionParticipant ... values) {
            Builder.addIf(Objects::nonNull, this.participants, (Object)value, (Object[])values);
            return this.self();
        }

        @Nonnull
        public Builder watcher(@Nullable InternalWatcher value) {
            return this.watchers(value, new InternalWatcher[0]);
        }

        @Nonnull
        public Builder watchers(@Nullable Iterable<InternalWatcher> values) {
            Builder.addIf(Objects::nonNull, this.watchers, values);
            return this.self();
        }

        @Nonnull
        public Builder watchers(@Nullable InternalWatcher value, InternalWatcher ... values) {
            Builder.addIf(Objects::nonNull, this.watchers, (Object)value, (Object[])values);
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

