/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth.trusted;

import com.atlassian.bitbucket.util.CustomPreconditions;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.auth.trusted.InternalTrustedApplication;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Cacheable
@Table(name="trusted_app_restriction", uniqueConstraints={@UniqueConstraint(columnNames={"trusted_app_id", "restriction_type", "restriction_value"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalTrustedApplicationRestriction {
    private static final String ID_GEN = "trustedAppRestrictionIdGenerator";
    static final String TABLE = "trusted_app_restriction";
    @TableGenerator(name="trustedAppRestrictionIdGenerator", table="id_sequence", pkColumnValue="trusted_app_restriction", allocationSize=10)
    @Id
    @GeneratedValue(generator="trustedAppRestrictionIdGenerator", strategy=GenerationType.TABLE)
    private final Integer id;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="trusted_app_id", nullable=false)
    private final InternalTrustedApplication application;
    @Column(name="restriction_type", nullable=false)
    private final Short type;
    @Column(name="restriction_value", nullable=false)
    @RequiredString(size=255)
    private final String value;

    protected InternalTrustedApplicationRestriction() {
        this.id = null;
        this.application = null;
        this.type = null;
        this.value = null;
    }

    InternalTrustedApplicationRestriction(InternalTrustedApplication application, Type type, String value) {
        this(null, application, type, value);
    }

    InternalTrustedApplicationRestriction(Integer id, InternalTrustedApplication application, Type type, String value) {
        this.id = id;
        this.application = application;
        this.type = type != null ? Short.valueOf(type.getDbValue()) : null;
        this.value = value;
        CustomPreconditions.checkRequiredString((String)value, (int)255);
    }

    public Integer getId() {
        return this.id;
    }

    public Type getType() {
        return this.type != null ? Type.fromDbValue(this.type) : null;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalTrustedApplicationRestriction)) {
            return false;
        }
        InternalTrustedApplicationRestriction that = (InternalTrustedApplicationRestriction)o;
        return (this.application == null ? that.application == null : this.application.equals(that.application)) && (this.type == null ? that.type == null : this.type.equals(that.type)) && (this.value == null ? that.value == null : this.value.equals(that.value));
    }

    public int hashCode() {
        int result = this.application != null ? this.application.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public static enum Type {
        IP(0),
        URL(1);

        private final short dbValue;

        private Type(int dbValue) {
            this.dbValue = (short)dbValue;
        }

        public short getDbValue() {
            return this.dbValue;
        }

        public static Type fromDbValue(short dbValue) {
            for (Type type : Type.values()) {
                if (type.getDbValue() != dbValue) continue;
                return type;
            }
            throw new IllegalArgumentException();
        }
    }
}

