/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth.trusted;

import com.atlassian.bitbucket.util.CustomPreconditions;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.google.common.base.Charsets;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.apache.commons.codec.binary.Base64;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Cacheable
@Table(name="current_app")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalCurrentApplication {
    private static final String ID_GEN = "currentApplicationIdGenerator";
    static final String TABLE = "current_app";
    @TableGenerator(name="currentApplicationIdGenerator", table="id_sequence", pkColumnValue="current_app", allocationSize=10)
    @Id
    @GeneratedValue(generator="currentApplicationIdGenerator", strategy=GenerationType.TABLE)
    private final Integer id;
    @Column(name="application_id", nullable=false, unique=true)
    @RequiredString(size=255)
    private final String applicationId;
    @Column(name="public_key_base64", nullable=false)
    @RequiredString(size=4000)
    private final String publicKeyBase64;
    @Transient
    private volatile transient byte[] publicKey;
    @Column(name="private_key_base64", nullable=false)
    @RequiredString(size=4000)
    private final String privateKeyBase64;
    @Transient
    private volatile transient byte[] privateKey;

    protected InternalCurrentApplication() {
        this.id = null;
        this.applicationId = null;
        this.publicKeyBase64 = null;
        this.privateKeyBase64 = null;
    }

    public InternalCurrentApplication(String applicationId, byte[] publicKey, byte[] privateKey) {
        this(null, applicationId, publicKey, privateKey);
    }

    protected InternalCurrentApplication(Integer id, String applicationId, byte[] publicKey, byte[] privateKey) {
        this.id = id;
        this.applicationId = applicationId;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.publicKeyBase64 = new String(Base64.encodeBase64((byte[])publicKey), Charsets.UTF_8);
        this.privateKeyBase64 = new String(Base64.encodeBase64((byte[])privateKey), Charsets.UTF_8);
        CustomPreconditions.checkRequiredString((String)applicationId, (int)255);
        CustomPreconditions.checkRequiredString((String)this.publicKeyBase64, (int)4000);
        CustomPreconditions.checkRequiredString((String)this.privateKeyBase64, (int)4000);
    }

    public Integer getId() {
        return this.id;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public byte[] getPublicKey() {
        if (this.publicKey == null) {
            this.publicKey = Base64.decodeBase64((byte[])this.publicKeyBase64.getBytes(Charsets.UTF_8));
        }
        return this.publicKey;
    }

    public byte[] getPrivateKey() {
        if (this.privateKey == null) {
            this.privateKey = Base64.decodeBase64((byte[])this.privateKeyBase64.getBytes(Charsets.UTF_8));
        }
        return this.privateKey;
    }
}

