/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.activity;

import com.atlassian.bitbucket.activity.Activity;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.entity.InternalAbstractEntity;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Cacheable
@DiscriminatorColumn(name="activity_type", discriminatorType=DiscriminatorType.INTEGER)
@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="sta_activity", indexes={@Index(name="idx_sta_activity_type", columnList="activity_type"), @Index(name="idx_sta_activity_user", columnList="user_id")})
@TableGenerator(allocationSize=37, pkColumnValue="sta_activity", name="entityIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public abstract class InternalActivity
extends InternalAbstractEntity
implements Activity,
Initializable {
    public static final String TABLE = "sta_activity";
    @Column(name="created_timestamp", nullable=false, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date createdDate;
    @Column(name="activity_type", nullable=false, updatable=false)
    private final int type;
    @JoinColumn(name="user_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_activity_user"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalApplicationUser user;

    protected InternalActivity() {
        this.createdDate = null;
        this.type = -1;
    }

    protected InternalActivity(AbstractActivityBuilder<?, ?> builder) {
        super(builder);
        this.createdDate = ((AbstractActivityBuilder)((Object)Preconditions.checkNotNull(builder, (Object)"builder"))).createdDate;
        this.user = ((AbstractActivityBuilder)builder).user;
        DiscriminatorValue value = this.getClass().getAnnotation(DiscriminatorValue.class);
        if (value == null) {
            throw new IllegalStateException("Activity class [" + this.getClass().getName() + "] does not have a DiscriminatorValue annotation");
        }
        this.type = Integer.parseInt(value.value());
    }

    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public int getType() {
        return this.type;
    }

    @Nonnull
    public InternalApplicationUser getUser() {
        return this.user;
    }

    @Override
    public void initialize() {
        this.user = HibernateUtils.initialize(this.getUser());
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    @Nonnull
    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.getId()).add("user", (Object)this.user);
    }

    public static abstract class AbstractActivityBuilder<B extends AbstractActivityBuilder<B, A>, A extends InternalActivity>
    extends InternalAbstractEntity.AbstractEntityBuilder<B, A> {
        private Date createdDate;
        private InternalApplicationUser user;

        protected AbstractActivityBuilder() {
            this.createdDate = new Date();
        }

        protected AbstractActivityBuilder(@Nonnull A activity) {
            super(activity);
            this.createdDate = ((InternalActivity)activity).getCreatedDate();
            this.user = ((InternalActivity)activity).getUser();
        }

        @Override
        @Nonnull
        public abstract A build();

        @Nonnull
        public B createdDate(@Nonnull Date value) {
            this.createdDate = (Date)Preconditions.checkNotNull((Object)value, (Object)"createdDate");
            return (B)((Object)this.self());
        }

        @Nonnull
        public B user(@Nonnull InternalApplicationUser value) {
            this.user = (InternalApplicationUser)Preconditions.checkNotNull((Object)value, (Object)"user");
            return (B)((Object)this.self());
        }

        @Override
        @Nonnull
        protected abstract B self();
    }
}

