/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.entity.InternalAbstractEntity;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;

@Entity
@Table(name="sta_pr_rescope_request", indexes={@Index(name="idx_sta_pr_rescope_req_repo", columnList="repo_id")})
@TableGenerator(allocationSize=43, pkColumnValue="sta_pr_rescope_request", name="entityIdGenerator", table="id_sequence")
public class InternalRescopeRequest
extends InternalAbstractEntity
implements Initializable {
    public static final Function<InternalRescopeRequest, Long> TO_ID = InternalAbstractEntity::getId;
    static final String TABLE = "sta_pr_rescope_request";
    @Column(name="branch_fqn")
    @OptionalString(size=1024)
    private final String branchId;
    @JoinColumn(name="repo_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_pr_rescope_req_repo"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalRepository repository;
    @JoinColumn(name="user_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_pr_rescope_req_user"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalApplicationUser user;

    protected InternalRescopeRequest() {
        this.branchId = null;
        this.repository = null;
        this.user = null;
    }

    public InternalRescopeRequest(Builder builder) {
        super(builder);
        this.branchId = builder.branchId;
        this.repository = builder.repository;
        this.user = builder.user;
    }

    @Nullable
    public String getBranchId() {
        return this.branchId;
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Nonnull
    public InternalApplicationUser getUser() {
        return this.user;
    }

    @Override
    public void initialize() {
        this.repository = HibernateUtils.initialize(this.getRepository());
        this.user = HibernateUtils.initialize(this.getUser());
    }

    public static class Builder
    extends InternalAbstractEntity.AbstractEntityBuilder<Builder, InternalRescopeRequest> {
        private final InternalRepository repository;
        private final InternalApplicationUser user;
        private String branchId;

        public Builder(@Nonnull InternalRescopeRequest request) {
            super(request);
            this.branchId = request.getBranchId();
            this.repository = Objects.requireNonNull(request.getRepository(), "request.repository");
            this.user = Objects.requireNonNull(request.getUser(), "request.user");
        }

        public Builder(@Nonnull InternalRepository repository, @Nonnull InternalApplicationUser user) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.user = Objects.requireNonNull(user, "user");
        }

        @Nonnull
        public Builder branchId(@Nullable String value) {
            this.branchId = value;
            return this.self();
        }

        @Override
        @Nonnull
        public InternalRescopeRequest build() {
            return new InternalRescopeRequest(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

