/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.pull.RescopeDetails;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class InternalRescopeDetails
implements RescopeDetails,
Serializable {
    public static final InternalRescopeDetails EMPTY = new InternalRescopeDetails();
    private static final Comparator<Commit> ORDER = new Comparator<Commit>(){

        @Override
        public int compare(Commit lhs, Commit rhs) {
            return rhs.getAuthorTimestamp().compareTo(lhs.getAuthorTimestamp());
        }
    };
    private final List<Commit> commits;
    private final int total;

    private InternalRescopeDetails() {
        this.commits = Collections.emptyList();
        this.total = 0;
    }

    private InternalRescopeDetails(Builder builder) {
        this.commits = ImmutableList.copyOf((Collection)builder.commits);
        this.total = builder.total;
    }

    @Nonnull
    public List<Commit> getCommits() {
        return this.commits;
    }

    public int getTotal() {
        return this.total;
    }

    public boolean isEmpty() {
        return this.total == 0;
    }

    public static class Builder
    extends BuilderSupport {
        private final List<Commit> commits;
        private int total;

        public Builder() {
            this.commits = Lists.newArrayList();
        }

        public Builder(@Nonnull InternalRescopeDetails details) {
            this.commits = Lists.newArrayList(((InternalRescopeDetails)Preconditions.checkNotNull((Object)details, (Object)"details")).getCommits());
            this.total = details.getTotal();
        }

        @Nonnull
        public InternalRescopeDetails build() {
            Collections.sort(this.commits, ORDER);
            return new InternalRescopeDetails(this);
        }

        @Nonnull
        public Builder commit(Commit value) {
            Builder.addIf(Objects::nonNull, this.commits, (Object)value);
            return this;
        }

        @Nonnull
        public Builder commits(Iterable<Commit> value) {
            Builder.addIf(Objects::nonNull, this.commits, value);
            return this;
        }

        @Nonnull
        public Builder total(int value) {
            this.total = value;
            return this;
        }
    }
}

