/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.comment.CommentableVisitor;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.watcher.WatchableVisitor;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.participant.InternalParticipable;
import com.atlassian.stash.internal.participant.ParticipableVisitor;
import com.atlassian.stash.internal.property.AbstractPropertySupport;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipant;
import com.atlassian.stash.internal.pull.InternalPullRequestRef;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.RepositoryScope;
import com.atlassian.stash.internal.repository.RepositoryScoped;
import com.atlassian.stash.internal.task.InternalTaskContext;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.InternalWatcher;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.AssociationOverride;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.Where;

@Cacheable
@Entity
@Table(name="sta_pull_request", indexes={@Index(name="idx_sta_pull_request_from", columnList="from_repository_id, from_branch_fqn"), @Index(name="idx_sta_pr_from_repo_update", columnList="from_repository_id, updated_timestamp"), @Index(name="idx_sta_pull_request_state", columnList="pr_state"), @Index(name="idx_sta_pull_request_to", columnList="to_repository_id, to_branch_fqn"), @Index(name="idx_sta_pr_to_repo_update", columnList="to_repository_id, updated_timestamp"), @Index(name="idx_sta_pr_update_ts", columnList="updated_timestamp")}, uniqueConstraints={@UniqueConstraint(name="uq_sta_pull_request_scoped_id", columnNames={"to_repository_id", "scoped_id"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalPullRequest
extends AbstractPropertySupport
implements Initializable,
InternalCommentable,
InternalParticipable<InternalPullRequestParticipant>,
InternalTaskContext,
InternalWatchable,
PullRequest,
RepositoryScoped {
    public static final String ID_GEN = "pullRequestIdGenerator";
    public static final String TABLE = "sta_pull_request";
    public static final long LOCK_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(10L);
    @Column(name="created_timestamp", nullable=false, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date createdDate;
    @Column(name="description")
    @Lob
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String description;
    @AssociationOverride(name="repository", foreignKey=@ForeignKey(name="fk_sta_pull_request_from_repo"), joinColumns={@JoinColumn(name="from_repository_id", nullable=false, updatable=false)})
    @AttributeOverrides(value={@AttributeOverride(name="displayId", column=@Column(name="from_branch_name", nullable=false, updatable=false)), @AttributeOverride(name="hash", column=@Column(name="from_hash", nullable=false)), @AttributeOverride(name="id", column=@Column(name="from_branch_fqn", nullable=false, updatable=false))})
    @Embedded
    private final InternalPullRequestRef fromRef;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="pullRequestIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(allocationSize=20, pkColumnValue="sta_pull_request", name="pullRequestIdGenerator", table="id_sequence")
    private final long id;
    @Column(name="locked_timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date lockedDate;
    @OneToMany(mappedBy="pullRequest", targetEntity=InternalPullRequestParticipant.class)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @OptimisticLock(excluded=true)
    private final Set<PullRequestParticipant> participants;
    @Column(name="scoped_id", nullable=false, updatable=false)
    private long scopedId;
    @Column(name="pr_state", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.pull.PullRequestState")})
    private final PullRequestState state;
    @Column(name="title", nullable=false)
    private final String title;
    @AssociationOverride(name="repository", foreignKey=@ForeignKey(name="fk_sta_pull_request_to_repo"), joinColumns={@JoinColumn(name="to_repository_id", nullable=false, updatable=false)})
    @AttributeOverrides(value={@AttributeOverride(name="displayId", column=@Column(name="to_branch_name", nullable=false)), @AttributeOverride(name="hash", column=@Column(name="to_hash", nullable=false)), @AttributeOverride(name="id", column=@Column(name="to_branch_fqn", nullable=false))})
    @Embedded
    private final InternalPullRequestRef toRef;
    @Column(name="updated_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date updatedDate;
    @Column(name="entity_version", nullable=false)
    @Version
    private final int version;
    @JoinColumn(name="watchable_id", updatable=false)
    @OneToMany(targetEntity=InternalWatcher.class)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @OptimisticLock(excluded=true)
    @Where(clause="watchable_type = 1")
    private final Set<Watcher> watchers;

    protected InternalPullRequest() {
        this.updatedDate = null;
        this.lockedDate = null;
        this.createdDate = null;
        this.title = null;
        this.description = null;
        this.toRef = null;
        this.fromRef = null;
        this.scopedId = 0L;
        this.id = 0L;
        this.participants = Sets.newHashSet();
        this.state = null;
        this.version = 0;
        this.watchers = Sets.newHashSet();
    }

    private InternalPullRequest(Builder builder) {
        super(builder);
        Date now = new Date();
        this.createdDate = (Date)MoreObjects.firstNonNull((Object)builder.createdDate, (Object)now);
        this.description = builder.description;
        this.fromRef = builder.fromRef;
        this.id = builder.id;
        this.lockedDate = builder.lockedDate;
        this.participants = Sets.newHashSet((Iterable)builder.participants);
        this.scopedId = builder.scopedId;
        this.state = builder.state;
        this.title = builder.title;
        this.toRef = builder.toRef;
        this.updatedDate = (Date)MoreObjects.firstNonNull((Object)builder.updatedDate, (Object)now);
        this.version = builder.version;
        this.watchers = Sets.newHashSet((Iterable)builder.watchers);
    }

    @Override
    public <T> T accept(@Nonnull CommentableVisitor<T> visitor) {
        return (T)visitor.visit((PullRequest)this);
    }

    @Override
    public <T> T accept(@Nonnull ParticipableVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <T> T accept(@Nonnull WatchableVisitor<T> visitor) {
        return (T)visitor.visit((PullRequest)this);
    }

    @Override
    public void addParticipant(@Nonnull InternalPullRequestParticipant participant) {
        this.participants.add(participant);
    }

    @Override
    public void addWatcher(@Nonnull InternalWatcher watcher) {
        this.watchers.add(watcher);
    }

    @Nonnull
    public PullRequestParticipant getAuthor() {
        Set<PullRequestParticipant> authors = this.getParticipantsFilteredByRole(PullRequestRole.AUTHOR);
        if (authors.isEmpty()) {
            throw new IllegalStateException("Pull request author could not be found in its participants");
        }
        if (authors.size() > 1) {
            throw new IllegalStateException("Pull request has more than one author");
        }
        return authors.stream().findFirst().orElse(null);
    }

    @Override
    @Nonnull
    public ApplicationUser getCreatedBy() {
        return this.getAuthor().getUser();
    }

    @Nonnull
    public Date getCreatedDate() {
        return new Date(this.createdDate.getTime());
    }

    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public InternalPullRequestRef getFromRef() {
        return this.fromRef;
    }

    public long getGlobalId() {
        return this.id;
    }

    @Override
    public long getId() {
        return this.getScopedId();
    }

    public Set<PullRequestParticipant> getAllParticipants() {
        return ImmutableSet.copyOf(this.participants);
    }

    @Nonnull
    public Set<PullRequestParticipant> getParticipants() {
        return this.getParticipantsFilteredByRole(PullRequestRole.PARTICIPANT);
    }

    @Nonnull
    public Set<PullRequestParticipant> getReviewers() {
        return this.getParticipantsFilteredByRole(PullRequestRole.REVIEWER);
    }

    @Override
    @Nonnull
    public InternalRepository getScopeRepository() {
        return this.getToRef().getRepository();
    }

    @Override
    @Nonnull
    public RepositoryScope getScope() {
        return RepositoryScope.PULL_REQUEST;
    }

    @Override
    public long getScopedId() {
        return this.scopedId;
    }

    @Nonnull
    public PullRequestState getState() {
        return this.state;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public Set<Watcher> getWatchers() {
        return Collections.unmodifiableSet(this.watchers);
    }

    @Nonnull
    public InternalPullRequestRef getToRef() {
        return this.toRef;
    }

    @Nonnull
    public Date getUpdatedDate() {
        return new Date(this.updatedDate.getTime());
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.getFromRef());
        HibernateUtils.initialize(this.getToRef());
        Hibernate.initialize(this.getWatchers());
        for (PullRequestParticipant participant : this.getAllParticipants()) {
            Hibernate.initialize((Object)participant);
            Hibernate.initialize((Object)participant.getUser());
        }
        for (Watcher watcher : this.getWatchers()) {
            Hibernate.initialize((Object)watcher);
            Hibernate.initialize((Object)watcher.getUser());
        }
    }

    public boolean isClosed() {
        return this.getState() != PullRequestState.OPEN;
    }

    public boolean isCrossRepository() {
        return !Objects.equals(this.getFromRef().getRepository().getId(), this.getToRef().getRepository().getId());
    }

    public boolean isLocked() {
        return InternalPullRequest.isLockValid(this.lockedDate);
    }

    public boolean isOpen() {
        return this.getState() == PullRequestState.OPEN;
    }

    @Override
    public void removeParticipant(@Nonnull InternalPullRequestParticipant participant) {
        this.participants.remove(participant);
    }

    @Override
    public void removeWatcher(@Nonnull InternalWatcher watcher) {
        this.watchers.remove(watcher);
    }

    @Override
    public void setScopedId(long value) {
        if (this.scopedId != 0L) {
            throw new IllegalStateException("You cannot set the scoped ID after it's been initialized");
        }
        this.scopedId = value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("title", (Object)this.title).toString();
    }

    private static boolean isLockValid(Date lockedDate) {
        return lockedDate != null && System.currentTimeMillis() - lockedDate.getTime() < LOCK_TIMEOUT_MILLIS;
    }

    private Set<PullRequestParticipant> getParticipantsFilteredByRole(PullRequestRole role) {
        return this.participants.stream().filter(role.getFilter()).collect(Collectors.toSet());
    }

    public static class Builder
    extends AbstractPropertySupport.PropertyBuilderSupport<Builder> {
        private final Set<PullRequestParticipant> participants;
        private final Set<Watcher> watchers;
        private Date createdDate;
        private String description;
        private InternalPullRequestRef fromRef;
        private long id;
        private Date lockedDate;
        private long scopedId;
        private PullRequestState state;
        private String title;
        private InternalPullRequestRef toRef;
        private Date updatedDate;
        private int version;

        public Builder() {
            this.scopedId = 0L;
            this.id = 0L;
            this.participants = Sets.newHashSet();
            this.watchers = Sets.newHashSet();
        }

        public Builder(@Nonnull InternalPullRequest pullRequest) {
            super(pullRequest);
            this.createdDate = pullRequest.getCreatedDate();
            this.description = pullRequest.getDescription();
            this.fromRef = pullRequest.getFromRef();
            this.id = pullRequest.getGlobalId();
            this.participants = Sets.newHashSet(pullRequest.getAllParticipants());
            this.scopedId = pullRequest.getScopedId();
            this.state = pullRequest.getState();
            this.title = pullRequest.getTitle();
            this.toRef = pullRequest.getToRef();
            this.updatedDate = pullRequest.getUpdatedDate();
            this.version = pullRequest.getVersion();
            this.watchers = Sets.newHashSet(pullRequest.getWatchers());
        }

        @Nonnull
        public InternalPullRequest build() {
            return new InternalPullRequest(this);
        }

        @Nonnull
        public Builder createdDate(@Nonnull Date value) {
            this.createdDate = value;
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public Builder fromRef(@Nonnull InternalPullRequestRef value) {
            this.fromRef = value;
            return this;
        }

        @Nonnull
        public Builder globalId(long value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public Builder locked(boolean value) {
            if (value) {
                if (!InternalPullRequest.isLockValid(this.lockedDate)) {
                    this.lockedDate = new Date();
                }
            } else {
                this.lockedDate = null;
            }
            return this;
        }

        @Nonnull
        public Builder participant(@Nullable PullRequestParticipant value) {
            return this.participants(value, new PullRequestParticipant[0]);
        }

        @Nonnull
        public Builder participants(@Nullable Iterable<PullRequestParticipant> values) {
            Builder.addIf(Objects::nonNull, this.participants, values);
            return this;
        }

        @Nonnull
        public Builder participants(@Nullable PullRequestParticipant value, PullRequestParticipant ... values) {
            Builder.addIf(Objects::nonNull, this.participants, (Object)value, (Object[])values);
            return this;
        }

        @Nonnull
        public Builder scopedId(long value) {
            this.scopedId = value;
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull PullRequestState value) {
            this.state = value;
            return this;
        }

        @Nonnull
        public Builder title(@Nonnull String value) {
            this.title = Builder.checkNotBlank((String)value, (String)"title");
            return this;
        }

        @Nonnull
        public Builder toRef(@Nonnull InternalPullRequestRef value) {
            this.toRef = value;
            return this;
        }

        @Nonnull
        public Builder updatedDate(@Nonnull Date value) {
            this.updatedDate = value;
            return this;
        }

        @Nonnull
        public Builder watcher(@Nullable InternalWatcher value) {
            return this.watchers(value, new InternalWatcher[0]);
        }

        @Nonnull
        public Builder watchers(@Nullable Iterable<InternalWatcher> values) {
            Builder.addIf(Objects::nonNull, this.watchers, values);
            return this;
        }

        @Nonnull
        public Builder watchers(@Nullable InternalWatcher value, InternalWatcher ... values) {
            Builder.addIf(Objects::nonNull, this.watchers, (Object)value, (Object[])values);
            return this;
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

