/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.util.CustomPreconditions;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.entity.InternalAbstractEntity;
import javax.annotation.Nonnull;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="plugin_setting", uniqueConstraints={@UniqueConstraint(name="uq_plug_setting_ns_key", columnNames={"key_name", "namespace"})})
@TableGenerator(allocationSize=20, pkColumnValue="plugin_setting", name="entityIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@NaturalIdCache
public class PluginSetting
extends InternalAbstractEntity {
    public static final String TABLE = "plugin_setting";
    @NaturalId
    @Column(name="namespace", nullable=false)
    @RequiredString(size=255)
    private final String namespace;
    @NaturalId
    @Column(name="key_name", nullable=false)
    @RequiredString(size=255)
    private final String key;
    @Column(name="key_value", nullable=false)
    @Lob
    @RequiredString(size=0x7FFFFFFF)
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String value;

    protected PluginSetting() {
        this.namespace = null;
        this.key = null;
        this.value = null;
    }

    private PluginSetting(Builder builder) {
        super(builder);
        CustomPreconditions.checkRequiredString((String)builder.key, (int)255);
        CustomPreconditions.checkRequiredString((String)builder.namespace, (int)255);
        CustomPreconditions.checkRequiredString((String)builder.value);
        this.key = builder.key;
        this.namespace = builder.namespace;
        this.value = builder.value;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public static class Builder
    extends InternalAbstractEntity.AbstractEntityBuilder<Builder, PluginSetting> {
        private String key;
        private String namespace;
        private String value;

        public Builder() {
        }

        public Builder(PluginSetting settings) {
            super(settings);
            this.key = settings.getKey();
            this.namespace = settings.getNamespace();
            this.value = settings.getValue();
        }

        @Override
        @Nonnull
        public PluginSetting build() {
            return new PluginSetting(this);
        }

        @Nonnull
        public Builder key(String value) {
            this.key = value;
            return this.self();
        }

        @Nonnull
        public Builder namespace(String value) {
            this.namespace = value;
            return this.self();
        }

        @Nonnull
        public Builder value(String value) {
            this.value = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

