/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.entity.InternalAbstractEntity;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.Hibernate;

@Entity
@Table(name="sta_remember_me_token")
@TableGenerator(allocationSize=20, pkColumnValue="sta_remember_me_token", name="entityIdGenerator", table="id_sequence")
public class InternalRememberMeToken
extends InternalAbstractEntity
implements Initializable {
    static final String TABLE = "sta_remember_me_token";
    @Column(name="series", nullable=false, updatable=false)
    @RequiredString(size=64)
    private final String series;
    @Column(name="token", nullable=false, updatable=false)
    @RequiredString(size=64)
    private final String token;
    @Column(name="claimed", nullable=false)
    private final boolean claimed;
    @Column(name="expiry_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date expiryDate;
    @Column(name="claimed_address")
    @OptionalString(size=255)
    private final String remoteAddress;
    @JoinColumn(name="user_id", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalApplicationUser user;

    protected InternalRememberMeToken() {
        this.claimed = false;
        this.expiryDate = null;
        this.remoteAddress = null;
        this.series = null;
        this.token = null;
        this.user = null;
    }

    private InternalRememberMeToken(Builder builder) {
        this.claimed = builder.claimed;
        this.expiryDate = builder.expiryDate;
        this.remoteAddress = builder.remoteAddress;
        this.series = builder.series;
        this.token = builder.token;
        this.user = builder.user;
    }

    @Nonnull
    public Date getExpiryDate() {
        return new Date(this.expiryDate.getTime());
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Nonnull
    public String getSeries() {
        return this.series;
    }

    @Nonnull
    public String getToken() {
        return this.token;
    }

    public ApplicationUser getUser() {
        return this.user;
    }

    @Override
    public void initialize() {
        Hibernate.initialize((Object)this.getUser());
    }

    public boolean isClaimed() {
        return this.claimed;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expiryDate.getTime();
    }

    public static class Builder
    extends InternalAbstractEntity.AbstractEntityBuilder<Builder, InternalRememberMeToken> {
        private boolean claimed;
        private Date expiryDate;
        private String remoteAddress;
        private String series;
        private String token;
        private InternalApplicationUser user;

        public Builder() {
        }

        public Builder(@Nonnull InternalRememberMeToken token) {
            super(token);
            this.claimed = token.claimed;
            this.expiryDate = ((InternalRememberMeToken)Preconditions.checkNotNull((Object)token, (Object)"token")).expiryDate;
            this.remoteAddress = token.remoteAddress;
            this.series = token.series;
            this.token = token.token;
            this.user = token.user;
        }

        @Override
        @Nonnull
        public InternalRememberMeToken build() {
            Preconditions.checkState((this.series != null ? 1 : 0) != 0, (Object)"Series must be set");
            Preconditions.checkState((this.token != null ? 1 : 0) != 0, (Object)"Token must be set");
            return new InternalRememberMeToken(this);
        }

        @Nonnull
        public Builder claimed() {
            this.claimed = true;
            return this.self();
        }

        @Nonnull
        public Builder expiresAfter(long time, @Nonnull TimeUnit timeUnit) {
            Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"timeUnit");
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.add(13, Ints.saturatedCast((long)timeUnit.toSeconds(time)));
            this.expiryDate = calendar.getTime();
            return this.self();
        }

        @Nonnull
        public Builder remoteAddress(@Nonnull String value) {
            this.remoteAddress = (String)Preconditions.checkNotNull((Object)value, (Object)"remoteAddress");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public Builder series(@Nonnull String value) {
            this.series = (String)Preconditions.checkNotNull((Object)value, (Object)"series");
            return this.self();
        }

        @Nonnull
        public Builder token(@Nonnull String value) {
            this.token = (String)Preconditions.checkNotNull((Object)value, (Object)"token");
            return this.self();
        }

        @Nonnull
        public Builder user(@Nonnull InternalApplicationUser value) {
            this.user = (InternalApplicationUser)Preconditions.checkNotNull((Object)value, (Object)"user");
            return this.self();
        }
    }
}

