/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.audit;

import com.atlassian.bitbucket.audit.Priority;
import com.atlassian.bitbucket.event.annotation.Audited;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.event.repository.RepositoryEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.stash.internal.jira.audit.DevSummaryPropertyEventConverter;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

@AsynchronousPreferred
@TransactionAware
@Audited(converter=DevSummaryPropertyEventConverter.class, channels={"audit.channel.ui.repository"}, priority=Priority.LOW)
public class DevSummaryPropertyEvent
extends RepositoryEvent {
    private String name;
    private String value;
    private Operation operation;

    public DevSummaryPropertyEvent(@Nonnull Repository repository, @Nonnull Operation operation, @Nonnull String name, @Nonnull String value, @Nonnull Object source) {
        super(source, repository);
        this.operation = (Operation)((Object)Preconditions.checkNotNull((Object)((Object)operation), (Object)"operation"));
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
    }

    @Nonnull
    public String getValue() {
        return this.value;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Operation getOperation() {
        return this.operation;
    }

    public static enum Operation {
        SET,
        REMOVE;


        public String toString() {
            return this.name();
        }
    }
}

