/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.summary.rest;

import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.jira.summary.InternalDevSummaryService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.sun.jersey.spi.resource.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="/detail")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class DevSummaryDetailResource {
    private static final Logger log = LoggerFactory.getLogger(DevSummaryDetailResource.class);
    private static final int MAX_SUMMARIES = 1000;
    private final InternalDevSummaryService devSummaryService;

    public DevSummaryDetailResource(InternalDevSummaryService devSummaryService) {
        this.devSummaryService = devSummaryService;
    }

    @Path(value="{type}")
    @GET
    public Response getIssueSummary(@PathParam(value="type") String type, @Deprecated @QueryParam(value="issue") List<String> issues, @QueryParam(value="globalId") List<String> globalIds) {
        ImmutableList issueKeys = ImmutableList.copyOf((Iterable)Iterables.limit((Iterable)Iterables.concat(issues, globalIds), (int)1000));
        int requestedCount = issues.size() + globalIds.size();
        if (requestedCount > 1000) {
            log.info("{} issue summaries requested but only {} will be processed", (Object)requestedCount, (Object)1000);
        }
        final Jsonable detail = this.devSummaryService.getDetail(type, (List<String>)issueKeys);
        return ResponseFactory.ok((Object)new StreamingOutput(){

            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                OutputStreamWriter writer = new OutputStreamWriter(outputStream);
                detail.write((Writer)writer);
                ((Writer)writer).flush();
            }
        }).build();
    }
}

