/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.config.conditions;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugins.capabilities.api.LinkedAppWithCapabilities;
import com.atlassian.plugins.capabilities.api.LinkedApplicationCapabilities;
import com.atlassian.stash.internal.jira.index.impl.IssueIndexingConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class SmartCommitsCondition
implements Condition {
    @VisibleForTesting
    static final String APP_LINK_CONTEXT_KEY = "applicationLink";
    @VisibleForTesting
    static final String SMART_COMMITS_CAPABILITY = "smart-commit-consumer";
    private IssueIndexingConfig issueIndexingConfig;
    private LinkedApplicationCapabilities linkedApplicationCapabilities;

    @Autowired
    public SmartCommitsCondition(@Nonnull IssueIndexingConfig issueIndexingConfig, @Nonnull LinkedApplicationCapabilities linkedApplicationCapabilities) {
        this.issueIndexingConfig = (IssueIndexingConfig)Preconditions.checkNotNull((Object)issueIndexingConfig);
        this.linkedApplicationCapabilities = (LinkedApplicationCapabilities)Preconditions.checkNotNull((Object)linkedApplicationCapabilities);
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        ApplicationLink applicationLink = (ApplicationLink)context.get(APP_LINK_CONTEXT_KEY);
        return applicationLink != null && !this.issueIndexingConfig.isSmartCommitsDisabled() && this.linkedApplicationCapabilities.capableOf(SMART_COMMITS_CAPABILITY).stream().map(LinkedAppWithCapabilities::getApplicationLinkId).anyMatch(appId -> applicationLink.getId().get().equals(appId));
    }
}

