/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.httpservice;

import com.atlassian.labs.httpservice.descriptors.HttpServiceServletModuleDescriptor;
import com.atlassian.labs.httpservice.descriptors.LegacyHttpServiceServletModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.ServletModuleDescriptor;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;

public class ServletManager {
    private final Plugin plugin;
    private final Bundle bundle;
    private final ServletModuleManager servletModuleManager;
    private final Map<String, ServletEntry> servletEntries;

    public ServletManager(Plugin plugin, Bundle bundle, ServletModuleManager servletModuleManager) {
        this.plugin = plugin;
        this.bundle = bundle;
        this.servletModuleManager = servletModuleManager;
        this.servletEntries = new HashMap<String, ServletEntry>();
    }

    public synchronized void addServlet(String alias, Servlet servlet, Dictionary params) {
        ServletModuleDescriptor descriptor = this.createServletDescriptor(alias, servlet, params);
        descriptor.enabled();
        ServiceRegistration reg = this.bundle.getBundleContext().registerService(ModuleDescriptor.class.getName(), (Object)descriptor, null);
        this.servletEntries.put(alias, new ServletEntry(descriptor, reg));
    }

    private ServletModuleDescriptor createServletDescriptor(String alias, Servlet servlet, Dictionary params) {
        try {
            this.getClass().getClassLoader().loadClass("com.atlassian.plugin.module.ModuleFactory");
            return new HttpServiceServletModuleDescriptor(this.plugin, servlet, alias, params, this.servletModuleManager);
        }
        catch (ClassNotFoundException e) {
            return new LegacyHttpServiceServletModuleDescriptor(this.plugin, servlet, alias, params, this.servletModuleManager);
        }
    }

    public synchronized void removeServlet(String alias) {
        if (this.servletEntries.containsKey(alias)) {
            ServletEntry entry = this.servletEntries.remove(alias);
            entry.getDescriptor().disabled();
            entry.getRegistration().unregister();
        }
    }

    public synchronized void removeAll() {
        for (String alias : this.servletEntries.keySet()) {
            this.removeServlet(alias);
        }
    }

    public ServletModuleDescriptor guessContext(String pathInfo) {
        if (pathInfo != null) {
            for (String alias : this.servletEntries.keySet()) {
                if (!pathInfo.startsWith(alias)) continue;
                return this.servletEntries.get(alias).getDescriptor();
            }
        }
        return null;
    }

    private static class ServletEntry {
        private final ServiceRegistration registration;
        private final ServletModuleDescriptor descriptor;

        public ServletEntry(ServletModuleDescriptor descriptor, ServiceRegistration registration) {
            this.descriptor = descriptor;
            this.registration = registration;
        }

        public ServiceRegistration getRegistration() {
            return this.registration;
        }

        public ServletModuleDescriptor getDescriptor() {
            return this.descriptor;
        }
    }
}

