/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.bundlerepository.R4Attribute;
import org.apache.felix.bundlerepository.R4Export;
import org.apache.felix.bundlerepository.R4Import;
import org.apache.felix.bundlerepository.R4Package;
import org.apache.felix.webconsole.internal.BaseWebConsolePlugin;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.servlet.OsgiManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class BundlesServlet
extends BaseWebConsolePlugin {
    public static final String NAME = "bundles";
    public static final String LABEL = "Bundles";
    public static final String BUNDLE_ID = "bundleId";
    private String[] bootPkgs;
    private boolean[] bootPkgWildcards;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$core$BundlesServlet;

    public void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
        String bootDelegation = bundleContext.getProperty("org.osgi.framework.bootdelegation");
        bootDelegation = bootDelegation == null ? "java.*" : bootDelegation + ",java.*";
        StringTokenizer st = new StringTokenizer(bootDelegation, " ,");
        this.bootPkgs = new String[st.countTokens()];
        this.bootPkgWildcards = new boolean[this.bootPkgs.length];
        for (int i = 0; i < this.bootPkgs.length; ++i) {
            bootDelegation = st.nextToken();
            if (bootDelegation.endsWith("*")) {
                this.bootPkgWildcards[i] = true;
                bootDelegation = bootDelegation.substring(0, bootDelegation.length() - 1);
            }
            this.bootPkgs[i] = bootDelegation;
        }
    }

    public String getLabel() {
        return NAME;
    }

    public String getTitle() {
        return LABEL;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestInfo reqInfo = new RequestInfo(request);
        if (reqInfo.bundle == null && reqInfo.bundleRequested) {
            response.sendError(404);
            return;
        }
        if (reqInfo.extension.equals("json")) {
            this.renderJSON(response, reqInfo.bundle);
            return;
        }
        super.doGet(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RequestInfo reqInfo = new RequestInfo(req);
        if (reqInfo.bundle == null && reqInfo.bundleRequested) {
            resp.sendError(404);
            return;
        }
        boolean success = false;
        String action = req.getParameter("action");
        Bundle bundle = this.getBundle(req.getPathInfo());
        if (bundle != null) {
            if (action == null) {
                success = true;
            } else if ("start".equals(action)) {
                success = true;
                try {
                    bundle.start();
                }
                catch (BundleException be) {
                    this.getLog().log(1, "Cannot start", be);
                }
            } else if ("stop".equals(action)) {
                success = true;
                try {
                    bundle.stop();
                }
                catch (BundleException be) {
                    this.getLog().log(1, "Cannot stop", be);
                }
            } else if ("refresh".equals(action)) {
                this.refresh(bundle);
                success = true;
            } else if ("uninstall".equals(action)) {
                success = true;
                try {
                    bundle.uninstall();
                    bundle = null;
                }
                catch (BundleException be) {
                    this.getLog().log(1, "Cannot uninstall", be);
                }
            }
        }
        if ("refreshPackages".equals(action)) {
            this.getPackageAdmin().refreshPackages(null);
            success = true;
        }
        if (success) {
            try {
                Thread.sleep(800L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.renderJSON(resp, null);
        } else {
            super.doPost(req, resp);
        }
    }

    private Bundle getBundle(String pathInfo) {
        pathInfo = pathInfo.substring(pathInfo.lastIndexOf(47) + 1);
        try {
            long bundleId = Long.parseLong(pathInfo);
            if (bundleId >= 0L) {
                return this.getBundleContext().getBundle(bundleId);
            }
        }
        catch (NumberFormatException nfe) {
            String version;
            String symbolicName;
            int pos = pathInfo.indexOf(58);
            if (pos == -1) {
                symbolicName = pathInfo;
                version = null;
            } else {
                symbolicName = pathInfo.substring(0, pos);
                version = pathInfo.substring(pos + 1);
            }
            Bundle[] bundles = this.getBundleContext().getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                Bundle bundle = bundles[i];
                if (!symbolicName.equals(bundle.getSymbolicName()) || version != null && !version.equals(bundle.getHeaders().get("Bundle-Version"))) continue;
                return bundle;
            }
        }
        return null;
    }

    private void appendBundleInfoCount(StringBuffer buf, String msg, int count) {
        buf.append(count);
        buf.append(" bundle");
        if (count != 1) {
            buf.append('s');
        }
        buf.append(' ');
        buf.append(msg);
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestInfo reqInfo = BundlesServlet.getRequestInfo(request);
        PrintWriter pw = response.getWriter();
        String appRoot = (String)request.getAttribute(OsgiManager.ATTR_APP_ROOT);
        Util.script(pw, appRoot, "bundles.js");
        Util.startScript(pw);
        pw.println("var imgRoot = '" + appRoot + "/res/imgs';");
        pw.println("var startLevel = " + this.getStartLevel().getInitialBundleStartLevel() + ";");
        pw.println("var drawDetails = " + reqInfo.bundleRequested + ";");
        Util.endScript(pw);
        Util.script(pw, appRoot, "bundles.js");
        pw.println("<div id='plugin_content'/>");
        Util.startScript(pw);
        pw.print("renderBundles(");
        this.writeJSON(pw, reqInfo.bundle);
        pw.println(");");
        Util.endScript(pw);
    }

    private void renderJSON(HttpServletResponse response, Bundle bundle) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        PrintWriter pw = response.getWriter();
        this.writeJSON(pw, bundle);
    }

    private void writeJSON(PrintWriter pw, Bundle bundle) throws IOException {
        Bundle[] bundleArray;
        Bundle[] allBundles = this.getBundles();
        String statusLine = this.getStatusLine(allBundles);
        if (bundle != null) {
            Bundle[] bundleArray2 = new Bundle[1];
            bundleArray = bundleArray2;
            bundleArray2[0] = bundle;
        } else {
            bundleArray = allBundles;
        }
        Bundle[] bundles = bundleArray;
        Util.sort(bundles);
        JSONWriter jw = new JSONWriter((Writer)pw);
        try {
            jw.object();
            jw.key("status");
            jw.value((Object)statusLine);
            jw.key("data");
            jw.array();
            for (int i = 0; i < bundles.length; ++i) {
                this.bundleInfo(jw, bundles[i], bundle != null);
            }
            jw.endArray();
            jw.endObject();
        }
        catch (JSONException je) {
            throw new IOException(je.toString());
        }
    }

    private String getStatusLine(Bundle[] bundles) {
        int active = 0;
        int installed = 0;
        int resolved = 0;
        block5: for (int i = 0; i < bundles.length; ++i) {
            switch (bundles[i].getState()) {
                case 32: {
                    ++active;
                    continue block5;
                }
                case 2: {
                    ++installed;
                    continue block5;
                }
                case 4: {
                    ++resolved;
                }
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Bundle information: ");
        this.appendBundleInfoCount(buffer, "in total", bundles.length);
        if (active == bundles.length) {
            buffer.append(" - all ");
            this.appendBundleInfoCount(buffer, "active.", bundles.length);
        } else {
            if (active != 0) {
                buffer.append(", ");
                this.appendBundleInfoCount(buffer, "active", active);
            }
            if (resolved != 0) {
                buffer.append(", ");
                this.appendBundleInfoCount(buffer, "resolved", resolved);
            }
            if (installed != 0) {
                buffer.append(", ");
                this.appendBundleInfoCount(buffer, "installed", installed);
            }
            buffer.append('.');
        }
        return buffer.toString();
    }

    private void bundleInfo(JSONWriter jw, Bundle bundle, boolean details) throws JSONException {
        jw.object();
        jw.key("id");
        jw.value(bundle.getBundleId());
        jw.key("name");
        jw.value((Object)Util.getName(bundle));
        jw.key("state");
        jw.value((Object)this.toStateString(bundle.getState()));
        jw.key("actions");
        jw.array();
        if (bundle.getBundleId() != 0L) {
            if (this.hasStart(bundle)) {
                this.action(jw, this.hasStart(bundle), "start", "Start", "start");
            } else {
                this.action(jw, this.hasStop(bundle), "stop", "Stop", "stop");
            }
            this.action(jw, true, "refresh", "Refresh Package Imports", "refresh");
            this.action(jw, this.hasUninstall(bundle), "uninstall", "Uninstall", "delete");
        }
        jw.endArray();
        if (details) {
            this.bundleDetails(jw, bundle);
        }
        jw.endObject();
    }

    protected Bundle[] getBundles() {
        return this.getBundleContext().getBundles();
    }

    private String toStateString(int bundleState) {
        switch (bundleState) {
            case 2: {
                return "Installed";
            }
            case 4: {
                return "Resolved";
            }
            case 8: {
                return "Starting";
            }
            case 32: {
                return "Active";
            }
            case 16: {
                return "Stopping";
            }
            case 1: {
                return "Uninstalled";
            }
        }
        return "Unknown: " + bundleState;
    }

    private void action(JSONWriter jw, boolean enabled, String op, String opLabel, String image) throws JSONException {
        jw.object();
        jw.key("enabled").value(enabled);
        jw.key("name").value((Object)opLabel);
        jw.key("link").value((Object)op);
        jw.key("image").value((Object)image);
        jw.endObject();
    }

    private boolean hasStart(Bundle bundle) {
        return bundle.getState() == 2 || bundle.getState() == 4;
    }

    private boolean hasStop(Bundle bundle) {
        return bundle.getState() == 32;
    }

    private boolean hasUninstall(Bundle bundle) {
        return bundle.getState() == 2 || bundle.getState() == 4 || bundle.getState() == 32;
    }

    private void bundleDetails(JSONWriter jw, Bundle bundle) throws JSONException {
        Dictionary headers = bundle.getHeaders();
        jw.key("props");
        jw.array();
        this.keyVal(jw, "Symbolic Name", bundle.getSymbolicName());
        this.keyVal(jw, "Version", headers.get("Bundle-Version"));
        this.keyVal(jw, "Location", bundle.getLocation());
        this.keyVal(jw, "Last Modification", new Date(bundle.getLastModified()));
        String docUrl = (String)headers.get("Bundle-DocURL");
        if (docUrl != null) {
            this.keyVal(jw, "Bundle Documentation", docUrl);
        }
        this.keyVal(jw, "Vendor", headers.get("Bundle-Vendor"));
        this.keyVal(jw, "Copyright", headers.get("Bundle-Copyright"));
        this.keyVal(jw, "Description", headers.get("Bundle-Description"));
        this.keyVal(jw, "Start Level", this.getStartLevel(bundle));
        this.keyVal(jw, "Bundle Classpath", headers.get("Bundle-ClassPath"));
        if (bundle.getState() == 2) {
            this.listImportExportsUnresolved(jw, bundle);
        } else {
            this.listImportExport(jw, bundle);
        }
        this.listServices(jw, bundle);
        jw.endArray();
    }

    private Integer getStartLevel(Bundle bundle) {
        StartLevel sl = this.getStartLevel();
        return sl != null ? new Integer(sl.getBundleStartLevel(bundle)) : null;
    }

    private void listImportExport(JSONWriter jw, Bundle bundle) throws JSONException {
        JSONArray val;
        PackageAdmin packageAdmin = this.getPackageAdmin();
        if (packageAdmin == null) {
            return;
        }
        TreeMap<String, Bundle> usingBundles = new TreeMap<String, Bundle>();
        ExportedPackage[] exports = packageAdmin.getExportedPackages(bundle);
        if (exports != null && exports.length > 0) {
            Arrays.sort(exports, new Comparator(){

                public int compare(ExportedPackage p1, ExportedPackage p2) {
                    return p1.getName().compareTo(p2.getName());
                }

                public int compare(Object o1, Object o2) {
                    return this.compare((ExportedPackage)o1, (ExportedPackage)o2);
                }
            });
            val = new JSONArray();
            for (int j = 0; j < exports.length; ++j) {
                ExportedPackage export = exports[j];
                this.collectExport(val, export.getName(), export.getVersion());
                Bundle[] ubList = export.getImportingBundles();
                if (ubList == null) continue;
                for (int i = 0; i < ubList.length; ++i) {
                    Bundle ub = ubList[i];
                    usingBundles.put(ub.getSymbolicName(), ub);
                }
            }
            this.keyVal(jw, "Exported Packages", val);
        } else {
            this.keyVal(jw, "Exported Packages", "None");
        }
        exports = packageAdmin.getExportedPackages((Bundle)null);
        if (exports != null && exports.length > 0) {
            ArrayList<ExportedPackage> imports = new ArrayList<ExportedPackage>();
            block2: for (int i = 0; i < exports.length; ++i) {
                ExportedPackage ep = exports[i];
                Bundle[] importers = ep.getImportingBundles();
                for (int j = 0; importers != null && j < importers.length; ++j) {
                    if (importers[j].getBundleId() != bundle.getBundleId()) continue;
                    imports.add(ep);
                    continue block2;
                }
            }
            JSONArray val2 = new JSONArray();
            if (imports.size() > 0) {
                ExportedPackage[] packages = imports.toArray(new ExportedPackage[imports.size()]);
                Arrays.sort(packages, new Comparator(){

                    public int compare(ExportedPackage p1, ExportedPackage p2) {
                        return p1.getName().compareTo(p2.getName());
                    }

                    public int compare(Object o1, Object o2) {
                        return this.compare((ExportedPackage)o1, (ExportedPackage)o2);
                    }
                });
                for (int i = 0; i < packages.length; ++i) {
                    ExportedPackage ep = packages[i];
                    this.collectImport(val2, ep.getName(), ep.getVersion(), false, ep);
                }
            } else {
                val2.put((Object)"None");
            }
            this.keyVal(jw, "Imported Packages", val2);
        }
        if (!usingBundles.isEmpty()) {
            val = new JSONArray();
            Iterator ui = usingBundles.values().iterator();
            while (ui.hasNext()) {
                Bundle usingBundle = (Bundle)ui.next();
                val.put((Object)this.getBundleDescriptor(usingBundle));
            }
            this.keyVal(jw, "Importing Bundles", val);
        }
    }

    private void listImportExportsUnresolved(JSONWriter jw, Bundle bundle) throws JSONException {
        int i;
        R4Package[] pkgs;
        Dictionary dict = bundle.getHeaders();
        String target = (String)dict.get("Export-Package");
        if (target != null) {
            pkgs = R4Package.parseImportOrExportHeader((String)target);
            if (pkgs != null && pkgs.length > 0) {
                Arrays.sort(pkgs, new Comparator(){

                    public int compare(R4Package p1, R4Package p2) {
                        return p1.getName().compareTo(p2.getName());
                    }

                    public int compare(Object o1, Object o2) {
                        return this.compare((R4Package)o1, (R4Package)o2);
                    }
                });
                JSONArray val = new JSONArray();
                for (i = 0; i < pkgs.length; ++i) {
                    R4Export export = new R4Export(pkgs[i]);
                    this.collectExport(val, export.getName(), export.getVersion());
                }
                this.keyVal(jw, "Exported Packages", val);
            } else {
                this.keyVal(jw, "Exported Packages", "None");
            }
        }
        if ((target = (String)dict.get("Import-Package")) != null && (pkgs = R4Package.parseImportOrExportHeader((String)target)) != null && pkgs.length > 0) {
            ExportedPackage[] exports;
            TreeMap<String, R4Import> imports = new TreeMap<String, R4Import>();
            for (i = 0; i < pkgs.length; ++i) {
                R4Package pkg = pkgs[i];
                imports.put(pkg.getName(), new R4Import(pkg));
            }
            HashMap<String, ExportedPackage> candidates = new HashMap<String, ExportedPackage>();
            PackageAdmin packageAdmin = this.getPackageAdmin();
            if (packageAdmin != null && (exports = packageAdmin.getExportedPackages((Bundle)null)) != null && exports.length > 0) {
                for (int i2 = 0; i2 < exports.length; ++i2) {
                    ExportedPackage ep = exports[i2];
                    R4Import imp = (R4Import)imports.get(ep.getName());
                    if (imp == null || !imp.isSatisfied(this.toR4Export(ep))) continue;
                    candidates.put(ep.getName(), ep);
                }
            }
            JSONArray val = new JSONArray();
            if (imports.size() > 0) {
                Iterator ii = imports.values().iterator();
                while (ii.hasNext()) {
                    String path;
                    R4Import r4Import = (R4Import)ii.next();
                    ExportedPackage ep = (ExportedPackage)candidates.get(r4Import.getName());
                    if (ep == null && bundle.getResource(path = r4Import.getName().replace('.', '/')) != null) continue;
                    this.collectImport(val, r4Import.getName(), r4Import.getVersion(), r4Import.isOptional(), ep);
                }
            } else {
                val.put((Object)"None");
            }
            this.keyVal(jw, "Imported Packages", val);
        }
    }

    private void listServices(JSONWriter jw, Bundle bundle) throws JSONException {
        ServiceReference[] refs = bundle.getRegisteredServices();
        if (refs == null || refs.length == 0) {
            return;
        }
        for (int i = 0; i < refs.length; ++i) {
            String key = "Service ID " + refs[i].getProperty("service.id");
            JSONArray val = new JSONArray();
            this.appendProperty(val, refs[i], "objectClass", "Types");
            this.appendProperty(val, refs[i], "service.pid", "PID");
            this.appendProperty(val, refs[i], "service.factoryPid", "Factory PID");
            this.appendProperty(val, refs[i], "component.name", "Component Name");
            this.appendProperty(val, refs[i], "component.id", "Component ID");
            this.appendProperty(val, refs[i], "component.factory", "Component Factory");
            this.appendProperty(val, refs[i], "service.description", "Description");
            this.appendProperty(val, refs[i], "service.vendor", "Vendor");
            this.keyVal(jw, key, val);
        }
    }

    private void appendProperty(JSONArray array, ServiceReference ref, String name, String label) {
        StringBuffer dest = new StringBuffer();
        Object value = ref.getProperty(name);
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            dest.append(label).append(": ");
            for (int j = 0; j < values.length; ++j) {
                if (j > 0) {
                    dest.append(", ");
                }
                dest.append(values[j]);
            }
            array.put((Object)dest.toString());
        } else if (value != null) {
            dest.append(label).append(": ").append(value);
            array.put((Object)dest.toString());
        }
    }

    private void keyVal(JSONWriter jw, String key, Object value) throws JSONException {
        if (key != null && value != null) {
            jw.object();
            jw.key("key");
            jw.value((Object)key);
            jw.key("value");
            jw.value(value);
            jw.endObject();
        }
    }

    private void collectExport(JSONArray array, String name, Version version) {
        StringBuffer val = new StringBuffer();
        boolean bootDel = this.isBootDelegated(name);
        if (bootDel) {
            val.append("!! ");
        }
        val.append(name);
        val.append(",version=");
        val.append(version);
        if (bootDel) {
            val.append(" -- Overwritten by Boot Delegation");
        }
        array.put((Object)val.toString());
    }

    private void collectImport(JSONArray array, String name, Version version, boolean optional, ExportedPackage export) {
        StringBuffer val = new StringBuffer();
        boolean bootDel = this.isBootDelegated(name);
        String marker = null;
        val.append(name);
        val.append(",version=").append(version);
        val.append(" from ");
        if (export != null) {
            val.append(this.getBundleDescriptor(export.getExportingBundle()));
            if (bootDel) {
                val.append(" -- Overwritten by Boot Delegation");
                marker = "INFO";
            }
        } else {
            val.append(" -- Cannot be resolved");
            marker = "ERROR";
            if (optional) {
                val.append(" but is not required");
            }
            if (bootDel) {
                val.append(" and overwritten by Boot Delegation");
            }
        }
        if (marker != null) {
            val.insert(0, ": ");
            val.insert(0, marker);
        }
        array.put((Object)val);
    }

    private boolean isBootDelegated(String pkgName) {
        if (pkgName.length() > 0) {
            for (int i = 0; i < this.bootPkgs.length; ++i) {
                if ((!this.bootPkgWildcards[i] || !pkgName.startsWith(this.bootPkgs[i]) && !this.bootPkgs[i].regionMatches(0, pkgName, 0, pkgName.length())) && (this.bootPkgWildcards[i] || !this.bootPkgs[i].equals(pkgName))) continue;
                return true;
            }
        }
        return false;
    }

    private R4Export toR4Export(ExportedPackage export) {
        R4Attribute version = new R4Attribute("version", export.getVersion().toString(), false);
        return new R4Export(export.getName(), null, new R4Attribute[]{version});
    }

    private String getBundleDescriptor(Bundle bundle) {
        StringBuffer val = new StringBuffer();
        if (bundle.getSymbolicName() != null) {
            val.append(bundle.getSymbolicName());
            val.append(" (").append(bundle.getBundleId());
            val.append(")");
        } else if (bundle.getLocation() != null) {
            val.append(bundle.getLocation());
            val.append(" (").append(bundle.getBundleId());
            val.append(")");
        } else {
            val.append(bundle.getBundleId());
        }
        return val.toString();
    }

    private void refresh(Bundle bundle) {
        this.getPackageAdmin().refreshPackages(new Bundle[]{bundle});
    }

    public static RequestInfo getRequestInfo(HttpServletRequest request) {
        return (RequestInfo)request.getAttribute((class$org$apache$felix$webconsole$internal$core$BundlesServlet == null ? (class$org$apache$felix$webconsole$internal$core$BundlesServlet = BundlesServlet.class$("org.apache.felix.webconsole.internal.core.BundlesServlet")) : class$org$apache$felix$webconsole$internal$core$BundlesServlet).getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class RequestInfo {
        public final String extension;
        public final Bundle bundle;
        public final boolean bundleRequested;

        protected RequestInfo(HttpServletRequest request) {
            String info = request.getPathInfo();
            info = info.substring(BundlesServlet.this.getLabel().length() + 1);
            if (info.endsWith(".json")) {
                this.extension = "json";
                info = info.substring(0, info.length() - 5);
            } else {
                this.extension = "html";
            }
            String bundleInfo = null;
            if (info.startsWith("/")) {
                bundleInfo = info.substring(1);
            }
            if (bundleInfo == null) {
                this.bundle = null;
                this.bundleRequested = false;
            } else {
                this.bundle = BundlesServlet.this.getBundle(bundleInfo);
                this.bundleRequested = true;
            }
            request.setAttribute((class$org$apache$felix$webconsole$internal$core$BundlesServlet == null ? (class$org$apache$felix$webconsole$internal$core$BundlesServlet = BundlesServlet.class$("org.apache.felix.webconsole.internal.core.BundlesServlet")) : class$org$apache$felix$webconsole$internal$core$BundlesServlet).getName(), (Object)this);
        }
    }
}

