/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.dataeditor;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PluginDataEditorServlet
extends HttpServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final LoginUriProvider loginUriProvider;
    private final UserManager userManager;
    private final WebSudoManager webSudoManager;
    static final String JIRA_SERAPH_SECURITY_ORIGINAL_URL = "os_security_originalurl";
    static final String CONF_SERAPH_SECURITY_ORIGINAL_URL = "seraph_originalurl";

    public PluginDataEditorServlet(TemplateRenderer renderer, ApplicationProperties applicationProperties, LoginUriProvider loginUriProvider, UserManager userManager, WebSudoManager webSudoManager) {
        this.renderer = renderer;
        this.applicationProperties = applicationProperties;
        this.loginUriProvider = loginUriProvider;
        this.userManager = userManager;
        this.webSudoManager = webSudoManager;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
            if (!this.userManager.isSystemAdmin(this.userManager.getRemoteUsername(request))) {
                this.redirectToLogin(request, response);
                return;
            }
            response.setContentType("text/html");
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("baseUrl", this.applicationProperties.getBaseUrl());
            this.renderer.render("plugin-data-editor.vm", context, (Writer)response.getWriter());
        }
        catch (WebSudoSessionException wse) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        URI uri = this.getUri(request);
        this.addSessionAttributes(request, uri.toASCIIString());
        response.sendRedirect(this.loginUriProvider.getLoginUri(uri).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void addSessionAttributes(HttpServletRequest request, String uriString) {
        request.getSession().setAttribute(JIRA_SERAPH_SECURITY_ORIGINAL_URL, (Object)uriString);
        request.getSession().setAttribute(CONF_SERAPH_SECURITY_ORIGINAL_URL, (Object)uriString);
    }
}

