/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.httpservice.descriptors;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.module.LegacyModuleFactory;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.ServletModuleDescriptor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServiceServletModuleDescriptor
extends ServletModuleDescriptor {
    private final List<String> paths;
    private final Map<String, String> initParams;
    private final String completeKey;
    private final String key;
    private final Plugin plugin;
    private final HttpServlet servlet;

    public HttpServiceServletModuleDescriptor(Plugin plugin, final Servlet originalServlet, String alias, Dictionary initParams, ServletModuleManager servletModuleManager) {
        super((ModuleFactory)new LegacyModuleFactory(), servletModuleManager);
        this.plugin = plugin;
        HttpServlet servlet = null;
        servlet = !(originalServlet instanceof HttpServlet) ? new HttpServlet(){

            public void init(ServletConfig config) throws ServletException {
                originalServlet.init(config);
            }

            protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                originalServlet.service((ServletRequest)req, (ServletResponse)resp);
            }

            public void destroy() {
                originalServlet.destroy();
            }
        } : (HttpServlet)originalServlet;
        this.servlet = servlet;
        this.paths = Arrays.asList(alias, "/".equals(alias) ? "/*" : alias + "/*");
        HashMap<String, String> tmp = new HashMap<String, String>();
        Enumeration e = initParams.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            tmp.put(key, (String)initParams.get(key));
        }
        this.initParams = Collections.unmodifiableMap(tmp);
        this.key = alias + servlet.getClass().getSimpleName();
        this.completeKey = plugin.getKey() + ":" + this.key;
    }

    public String getPluginKey() {
        return this.plugin.getKey();
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public HttpServlet getModule() {
        return this.servlet;
    }

    public String getKey() {
        return this.key;
    }

    public String getCompleteKey() {
        return this.completeKey;
    }

    public String getName() {
        return this.servlet.getClass().getSimpleName();
    }

    public Class<HttpServlet> getModuleClass() {
        return this.servlet.getClass();
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }
}

