/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.system;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.internal.BaseWebConsolePlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class VMStatPlugin
extends BaseWebConsolePlugin {
    public static final String LABEL = "vmstat";
    public static final String TITLE = "System Information";
    private static final String ATTR_TERMINATED = "terminated";
    private static final String PARAM_SHUTDOWN_TIMER = "shutdown_timer";
    private static final String PARAM_SHUTDOWN_TYPE = "shutdown_type";
    private static final String PARAM_SHUTDOWN_TYPE_RESTART = "Restart";
    private static final String PARAM_SHUTDOWN_TYPE_STOP = "Stop";
    private static final long startDate = new Date().getTime();

    public String getLabel() {
        return LABEL;
    }

    public String getTitle() {
        return TITLE;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getParameter(PARAM_SHUTDOWN_TIMER) == null) {
            final boolean restart = PARAM_SHUTDOWN_TYPE_RESTART.equals(request.getParameter(PARAM_SHUTDOWN_TYPE));
            Thread t = new Thread("Stopper"){

                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    VMStatPlugin.this.getLog().log(3, "Shutting down server now!");
                    try {
                        Bundle systemBundle = VMStatPlugin.this.getBundleContext().getBundle(0L);
                        if (restart) {
                            systemBundle.update();
                        } else {
                            systemBundle.stop();
                        }
                    }
                    catch (BundleException be) {
                        VMStatPlugin.this.getLog().log(1, "Problem stopping or restarting the Framework", be);
                    }
                }
            };
            t.start();
            request.setAttribute(ATTR_TERMINATED, (Object)ATTR_TERMINATED);
            request.setAttribute(PARAM_SHUTDOWN_TYPE, (Object)new Boolean(restart));
        }
        this.doGet(request, response);
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        pw.println("");
        if (request.getAttribute(ATTR_TERMINATED) != null) {
            pw.println("<tr>");
            pw.println("<td colspan='2' class='techcontentcell'>");
            pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
            pw.println("<tr class='content'>");
            Object restart = request.getAttribute(PARAM_SHUTDOWN_TYPE);
            if (restart instanceof Boolean && ((Boolean)restart).booleanValue()) {
                pw.println("<th class='content important'>Framework is restarting. stand by ...</th>");
                pw.println("<td class='content'>");
                pw.println("<form name='reloadform' method='get'>");
                pw.println("<input class='submit important' type='submit' value='Reload')\">&nbsp;");
                pw.println("Reloading in <span id='reloadcountdowncell'>&nbsp;</span>");
                pw.println("<script language='JavaScript'>");
                pw.println("shutdown(10, 'reloadform', 'reloadcountdowncell');");
                pw.println("</script>");
                pw.println("</form>");
                pw.println("</td");
            } else {
                pw.println("<th class='content important'>Framework has been stopped.</th>");
            }
            pw.println("</tr>");
            pw.println("</table>");
            pw.println("</td>");
            pw.println("</tr>");
            return;
        }
        boolean shutdownTimer = false;
        String target = request.getRequestURI();
        if (request.getParameter(PARAM_SHUTDOWN_TIMER) != null) {
            target = this.getLabel();
            shutdownTimer = true;
        }
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        pw.println("<tr class='content'>");
        pw.println("<th colspan='2' class='content container'>Start Level Information:</th>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>System Start Level</td>");
        pw.println("<td class='content'>");
        pw.println("<form method='post'>");
        pw.println("<input type='hidden' name='action' value='setStartLevel'>");
        pw.println("<input class='input' type='text' size='3' name='systemStartLevel' value='" + this.getStartLevel().getStartLevel() + "'/>");
        pw.println("&nbsp;&nbsp;<input class='submit' type='submit' name='Set Start Level' value='Change'>");
        pw.println("</form>");
        pw.println("</td>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>Default Bundle Start Level</td>");
        pw.println("<td class='content'>");
        pw.println("<form method='post'>");
        pw.println("<input type='hidden' name='action' value='setStartLevel'>");
        pw.println("<input class='input' type='text' size='3' name='bundleStartLevel' value='" + this.getStartLevel().getInitialBundleStartLevel() + "'/>");
        pw.println("&nbsp;&nbsp;<input class='submit' type='submit' name='Set Start Level' value='Change'>");
        pw.println("</form>");
        pw.println("</td>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<td colspan='2' class='content'>&nbsp;</th>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<th colspan='2' class='content container'>Server Information:</th>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>Last Started</td>");
        pw.println("<td class='content'>");
        pw.println("<script language='JavaScript'>");
        pw.println("localDate(" + startDate + ")");
        pw.println("</script>");
        pw.println("</td>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<form name='shutdownform' method='post' action='" + target + "'>");
        pw.println("<td class='content'>Framework</td>");
        pw.println("<td class='content'>");
        if (!shutdownTimer) {
            pw.println("<input type='hidden' name='shutdown_timer' value='shutdown_timer'>");
            pw.println("<input class='submit important' type='submit' name='shutdown_type' value='Restart' onclick=\"return confirm('This will stop and restart the framework and all bundles. Please confirm to continue.')\">");
            pw.println("<input class='submit important' type='submit' name='shutdown_type' value='Stop' onclick=\"return confirm('This will stop the framework and all bundles. Please confirm to continue.')\">");
        } else {
            pw.println("<input type='hidden' name='shutdown_type' value='" + request.getParameter(PARAM_SHUTDOWN_TYPE) + "'>");
            pw.println("<input class='submit important' type='button' value='Abort' onclick=\"abort('" + request.getRequestURI() + "')\">&nbsp;");
            pw.println("Shutdown in <span id='countdowncell'>&nbsp;</span>");
            pw.println("<script language='JavaScript'>");
            pw.println("shutdown(3, 'shutdownform', 'countdowncell');");
            pw.println("</script>");
        }
        pw.println("</td>");
        pw.println("</form>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<td colspan='2' class='content'>&nbsp;</th>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<th colspan='2' class='content container'>Java Information:</th>");
        pw.println("</tr>");
        long freeMem = Runtime.getRuntime().freeMemory() / 1024L;
        long totalMem = Runtime.getRuntime().totalMemory() / 1024L;
        long usedMem = totalMem - freeMem;
        this.infoLine(pw, "Java Runtime", System.getProperty("java.runtime.name") + "(build " + System.getProperty("java.runtime.version") + ")");
        this.infoLine(pw, "Java Virtual Machine", System.getProperty("java.vm.name") + "(build " + System.getProperty("java.vm.version") + ", " + System.getProperty("java.vm.info") + ")");
        this.infoLine(pw, "Total Memory", totalMem + " KB");
        this.infoLine(pw, "Used Memory", usedMem + " KB");
        this.infoLine(pw, "Free Memory", freeMem + " KB");
        pw.println("<tr class='content'>");
        pw.println("<form method='post'>");
        pw.println("<td class='content'>Garbage Collection</td>");
        pw.println("<td class='content'>");
        pw.println("<input type='hidden' name='action' value='gc'>");
        pw.println("<input class='submit' type='submit' name='Collect Garbage' value='Run'>");
        pw.println("</form></td></tr>");
        pw.println("</table>");
    }

    private void infoLine(PrintWriter pw, String label, String value) {
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>" + label + "</td>");
        pw.println("<td class='content'>");
        pw.println(value);
        pw.println("</td></tr>");
    }
}

