/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rules;

import com.atlassian.bitbucket.test.DarkFeatureTestHelper;
import com.atlassian.bitbucket.test.annotations.RequiresDarkFeature;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class DarkFeatureRule
extends ExternalResource {
    private String[] featuresToEnable;
    private String[] originalEnabledFeatures;

    public Statement apply(Statement base, Description description) {
        this.featuresToEnable = DarkFeatureRule.getDarkFeaturesToEnable(description);
        if (this.featuresToEnable.length == 0) {
            return base;
        }
        this.originalEnabledFeatures = DarkFeatureTestHelper.getEnabledFeatures();
        return super.apply(base, description);
    }

    protected void after() {
        DarkFeatureTestHelper.disableDarkFeatures(new String[0]);
        DarkFeatureTestHelper.enableDarkFeatures(this.originalEnabledFeatures);
    }

    protected void before() throws Throwable {
        DarkFeatureTestHelper.enableDarkFeatures(this.featuresToEnable);
    }

    private static String[] getDarkFeaturesToEnable(Description description) {
        RequiresDarkFeature descriptionAnnotation = (RequiresDarkFeature)description.getAnnotation(RequiresDarkFeature.class);
        RequiresDarkFeature classAnnotation = description.getTestClass().getAnnotation(RequiresDarkFeature.class);
        return (String[])Stream.of(descriptionAnnotation, classAnnotation).filter(Objects::nonNull).flatMap(annotation -> Arrays.stream(annotation.value())).distinct().toArray(String[]::new);
    }
}

