/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.restrictionprocessing;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.settingsrestriction.SettingsKey;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.time.Duration;
import javax.ws.rs.core.Response;
import org.hamcrest.Description;

public class RestrictionProcessingSuspenderHelper {
    private static final long WAIT_TIMEOUT = Duration.ofMinutes(2L).toMillis();

    private RestrictionProcessingSuspenderHelper() {
        throw new UnsupportedOperationException("Utility class can't be instantiated");
    }

    public static void deleteProcessorSettingsKey() {
        ((RequestSpecification)RestAssured.given().log().ifValidationFails()).expect().statusCode(Response.Status.OK.getStatusCode()).when().delete(RestrictionProcessingSuspenderHelper.getRestUrl() + "/settings-key", new Object[0]);
    }

    public static void resumeAndSuspendTestProcessor() {
        RestrictionProcessingSuspenderHelper.postToSuspender("/resume-and-suspend");
    }

    public static void resumeTestProcessor() {
        RestrictionProcessingSuspenderHelper.postToSuspender("/resume");
    }

    public static void setProcessingResult(boolean newProcessingResult) {
        ((RequestSpecification)RestAssured.given().log().ifValidationFails()).queryParam("result", new Object[]{newProcessingResult}).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(RestrictionProcessingSuspenderHelper.getRestUrl() + "/set-result", new Object[0]);
    }

    public static void setProcessorSettingsKey(SettingsKey settingsKey) {
        ((RequestSpecification)RestAssured.given().log().ifValidationFails()).queryParam("namespace", new Object[]{settingsKey.getNamespace()}).queryParam("featureKey", new Object[]{settingsKey.getFeatureKey()}).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(RestrictionProcessingSuspenderHelper.getRestUrl() + "/settings-key", new Object[0]);
    }

    public static void suspendTestProcessor() {
        RestrictionProcessingSuspenderHelper.postToSuspender("/suspend");
    }

    public static void waitUntilTestProcessorSuspended() {
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public void describeFailure(Description description) {
                description.appendText("The processor failed to be suspended after " + WAIT_TIMEOUT + " ms");
            }

            public boolean test() {
                return RestrictionProcessingSuspenderHelper.postToSuspender("/wait-until-suspended").getStatusCode() == Response.Status.OK.getStatusCode();
            }
        }, (long)WAIT_TIMEOUT);
    }

    public static void waitUntilTestProcessorSuspendedAndRetry(int retryCount) {
        for (int i = 0; i < retryCount; ++i) {
            RestrictionProcessingSuspenderHelper.waitUntilTestProcessorSuspended();
            RestrictionProcessingSuspenderHelper.resumeAndSuspendTestProcessor();
        }
        RestrictionProcessingSuspenderHelper.waitUntilTestProcessorSuspended();
    }

    private static String getRestUrl() {
        return DefaultFuncTestData.getRestURL("restriction-processing-tests", "latest") + "/suspender";
    }

    private static Response postToSuspender(String path) {
        return (Response)((RequestSpecification)RestAssured.given().log().ifValidationFails()).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(RestrictionProcessingSuspenderHelper.getRestUrl() + path, new Object[0]);
    }
}

